/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.aiki;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.up.aiki.Calculator;
import io.vertx.up.aiki.Debug;
import io.vertx.up.aiki.Fluctuate;
import io.vertx.up.aiki.From;
import io.vertx.up.aiki.In;
import io.vertx.up.aiki.Pagination;
import io.vertx.up.aiki.Pool;
import io.vertx.up.aiki.Query;
import io.vertx.up.aiki.To;
import io.vertx.up.aiki.UxJooq;
import io.vertx.up.aiki.UxMongo;
import io.vertx.up.aiki.UxRpc;
import io.vertx.up.aiki.Wait;
import io.vertx.up.aiki.Web;
import io.vertx.up.atom.Envelop;
import io.vertx.up.atom.query.Inquiry;
import io.vertx.up.atom.query.Pager;
import io.vertx.up.atom.query.Sorter;
import io.vertx.up.exception.WebException;
import io.vertx.up.func.Fn;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Ux {
    public static void debug(Object ... objects) {
        for (Object reference : objects) {
            Debug.monitor(reference);
        }
    }

    public static JsonObject toPagerJson(int page, int size) {
        return Pagination.toPager(page, size).toJson();
    }

    public static Pager toPager(int page, int size) {
        return Pagination.toPager(page, size);
    }

    public static Pager toPager(JsonObject data) {
        return Pagination.toPager(data);
    }

    public static Sorter toSorter(String field, boolean asc) {
        return Pagination.toSorter(field, asc);
    }

    public static Sorter toSorter(String field, int mode) {
        return Pagination.toSorter(field, mode);
    }

    public static <T> JsonObject toJson(T entity) {
        return To.toJson(entity, "");
    }

    public static <T> JsonObject toJson(T entity, String pojo) {
        return To.toJson(entity, pojo);
    }

    public static <T> T fromJson(JsonObject data, Class<T> clazz) {
        return From.fromJson(data, clazz, "");
    }

    public static <T> T fromJson(JsonObject data, Class<T> clazz, String pojo) {
        return From.fromJson(data, clazz, pojo);
    }

    public static <T> JsonObject toJsonFun(T entity, Function<JsonObject, JsonObject> convert) {
        return To.toJson(entity, convert);
    }

    public static <T> JsonObject toJsonByGroup(JsonArray array, String field) {
        return Calculator.groupBy(array, field);
    }

    public static void appendJson(JsonObject target, JsonObject source) {
        Calculator.appendJson(target, source);
    }

    public static WebException toError(Class<? extends WebException> clazz, Object ... args) {
        return To.toError(clazz, args);
    }

    public static WebException toError(Class<?> clazz, Throwable error) {
        return To.toError(clazz, error);
    }

    public static <T> JsonArray toArray(List<T> list) {
        return To.toArray(list, "");
    }

    public static <T> JsonArray toArray(List<T> list, String pojo) {
        return To.toArray(list, pojo);
    }

    public static <T> JsonArray toArrayFun(List<T> list, Function<JsonObject, JsonObject> convert) {
        return To.toArray(list, convert);
    }

    public static <T> Envelop to(List<T> list) {
        return Envelop.success(Ux.toArray(list));
    }

    public static Envelop to(Class<? extends WebException> clazz, Object ... args) {
        return To.toEnvelop(clazz, args);
    }

    public static <T> Envelop to(T entity) {
        return To.toEnvelop(entity);
    }

    public static <T> Envelop to(T entity, WebException error) {
        return To.toEnvelop(entity, error);
    }

    public static Envelop toOne(JsonArray array) {
        return Envelop.success(To.toUnique(array, ""));
    }

    public static <T> JsonObject toUnique(List<T> list) {
        return To.toUnique(Ux.toArray(list), "");
    }

    public static <T> JsonObject toUnique(List<T> list, String pojo) {
        return To.toUnique(Ux.toArray(list), pojo);
    }

    public static <T> JsonObject toUnique(JsonArray array) {
        return To.toUnique(array, "");
    }

    public static String getUserID(Message<Envelop> message, String field) {
        return In.requestUser(message, field);
    }

    public static String getUserID(Envelop envelop, String field) {
        return In.requestUser(envelop, field);
    }

    public static UUID getUserUUID(Message<Envelop> message, String field) {
        return UUID.fromString(Ux.getUserID(message, field));
    }

    public static UUID getUserUUID(Envelop envelop, String field) {
        return UUID.fromString(Ux.getUserID(envelop, field));
    }

    public static Object getSession(Message<Envelop> message, String field) {
        return In.requestSession(message, field);
    }

    public static Object getSession(Envelop envelop, String field) {
        return In.requestSession(envelop, field);
    }

    public static Future<JsonObject> fnRpc(JsonArray array) {
        return UxRpc.fnRpc(array);
    }

    public static <T> Handler<AsyncResult<T>> toHandler(Message<Envelop> message) {
        return Web.toHandler(message);
    }

    public static <T> Handler<AsyncResult<Boolean>> toHandler(Message<Envelop> message, JsonObject data) {
        return Web.toHandler(message, data);
    }

    public static JsonArray getArray(Message<Envelop> message, int index) {
        return In.request(message, (Integer)index, JsonArray.class);
    }

    public static JsonArray getArray(Envelop envelop, int index) {
        return In.request(envelop, (Integer)index, JsonArray.class);
    }

    public static JsonArray getArray(Message<Envelop> message) {
        return In.request(message, (Integer)0, JsonArray.class);
    }

    public static JsonArray getArray(Envelop envelop) {
        return In.request(envelop, (Integer)0, JsonArray.class);
    }

    public static JsonArray getArray1(Message<Envelop> message) {
        return In.request(message, (Integer)1, JsonArray.class);
    }

    public static JsonArray getArray1(Envelop envelop) {
        return In.request(envelop, (Integer)1, JsonArray.class);
    }

    public static JsonArray getArray2(Message<Envelop> message) {
        return In.request(message, (Integer)2, JsonArray.class);
    }

    public static JsonArray getArray2(Envelop envelop) {
        return In.request(envelop, (Integer)2, JsonArray.class);
    }

    public static JsonArray getArray3(Message<Envelop> message) {
        return In.request(message, (Integer)3, JsonArray.class);
    }

    public static JsonArray getArray3(Envelop envelop) {
        return In.request(envelop, (Integer)3, JsonArray.class);
    }

    public static String getString(Message<Envelop> message, int index) {
        return In.request(message, (Integer)index, String.class);
    }

    public static String getString(Envelop envelop, int index) {
        return In.request(envelop, (Integer)index, String.class);
    }

    public static String getString(Message<Envelop> message) {
        return In.request(message, (Integer)0, String.class);
    }

    public static String getString(Envelop envelop) {
        return In.request(envelop, (Integer)0, String.class);
    }

    public static String getString1(Message<Envelop> message) {
        return In.request(message, (Integer)1, String.class);
    }

    public static String getString1(Envelop envelop) {
        return In.request(envelop, (Integer)1, String.class);
    }

    public static String getString2(Message<Envelop> message) {
        return In.request(message, (Integer)2, String.class);
    }

    public static String getString2(Envelop envelop) {
        return In.request(envelop, (Integer)2, String.class);
    }

    public static String getString3(Message<Envelop> message) {
        return In.request(message, (Integer)3, String.class);
    }

    public static String getString3(Envelop envelop) {
        return In.request(envelop, (Integer)3, String.class);
    }

    public static JsonObject getJson(Message<Envelop> message, int index) {
        return In.request(message, (Integer)index, JsonObject.class);
    }

    public static JsonObject getJson(Envelop envelop, int index) {
        return In.request(envelop, (Integer)index, JsonObject.class);
    }

    public static JsonObject getJson(Message<Envelop> message) {
        return In.request(message, (Integer)0, JsonObject.class);
    }

    public static JsonObject getJson(Envelop envelop) {
        return In.request(envelop, (Integer)0, JsonObject.class);
    }

    public static Inquiry getInquiry(JsonObject envelop) {
        return Query.getInquiry(envelop, "");
    }

    public static Inquiry getInquiry(JsonObject envelop, String pojo) {
        return Query.getInquiry(envelop, pojo);
    }

    public static JsonObject getJson1(Message<Envelop> message) {
        return In.request(message, (Integer)1, JsonObject.class);
    }

    public static JsonObject getJson1(Envelop envelop) {
        return In.request(envelop, (Integer)1, JsonObject.class);
    }

    public static JsonObject getJson2(Message<Envelop> message) {
        return In.request(message, (Integer)2, JsonObject.class);
    }

    public static JsonObject getJson2(Envelop envelop) {
        return In.request(envelop, (Integer)2, JsonObject.class);
    }

    public static JsonObject getJson3(Message<Envelop> message) {
        return In.request(message, (Integer)3, JsonObject.class);
    }

    public static JsonObject getJson3(Envelop envelop) {
        return In.request(envelop, (Integer)3, JsonObject.class);
    }

    public static Integer getInteger(Message<Envelop> message, int index) {
        return In.request(message, (Integer)index, Integer.class);
    }

    public static Integer getInteger(Envelop envelop, int index) {
        return In.request(envelop, (Integer)index, Integer.class);
    }

    public static Integer getInteger(Message<Envelop> message) {
        return In.request(message, (Integer)0, Integer.class);
    }

    public static Integer getInteger(Envelop envelop) {
        return In.request(envelop, (Integer)0, Integer.class);
    }

    public static Integer getInteger1(Message<Envelop> message) {
        return In.request(message, (Integer)1, Integer.class);
    }

    public static Integer getInteger1(Envelop envelop) {
        return In.request(envelop, (Integer)1, Integer.class);
    }

    public static Integer getInteger2(Message<Envelop> message) {
        return In.request(message, (Integer)2, Integer.class);
    }

    public static Integer getInteger2(Envelop envelop) {
        return In.request(envelop, (Integer)2, Integer.class);
    }

    public static Integer getInteger3(Message<Envelop> message) {
        return In.request(message, (Integer)3, Integer.class);
    }

    public static Integer getInteger3(Envelop envelop) {
        return In.request(envelop, (Integer)3, Integer.class);
    }

    public static Long getLong(Message<Envelop> message, int index) {
        return In.request(message, (Integer)index, Long.class);
    }

    public static Long getLong(Envelop envelop, int index) {
        return In.request(envelop, (Integer)index, Long.class);
    }

    public static Long getLong(Message<Envelop> message) {
        return In.request(message, (Integer)0, Long.class);
    }

    public static Long getLong(Envelop envelop) {
        return In.request(envelop, (Integer)0, Long.class);
    }

    public static Long getLong1(Message<Envelop> message) {
        return In.request(message, (Integer)1, Long.class);
    }

    public static Long getLong1(Envelop envelop) {
        return In.request(envelop, (Integer)1, Long.class);
    }

    public static Long getLong2(Message<Envelop> message) {
        return In.request(message, (Integer)2, Long.class);
    }

    public static Long getLong2(Envelop envelop) {
        return In.request(envelop, (Integer)2, Long.class);
    }

    public static Long getLong3(Message<Envelop> message) {
        return In.request(message, (Integer)3, Long.class);
    }

    public static Long getLong3(Envelop envelop) {
        return In.request(envelop, (Integer)3, Long.class);
    }

    public static <T> T getT(Message<Envelop> message, int index, Class<T> clazz) {
        return In.request(message, (Integer)index, clazz);
    }

    public static <T> T getT(Envelop envelop, int index, Class<T> clazz) {
        return In.request(envelop, (Integer)index, clazz);
    }

    public static <T> T getT(Message<Envelop> message, Class<T> clazz) {
        return In.request(message, (Integer)0, clazz);
    }

    public static <T> T getT(Envelop envelop, Class<T> clazz) {
        return In.request(envelop, (Integer)0, clazz);
    }

    public static <T> T getT1(Message<Envelop> message, Class<T> clazz) {
        return In.request(message, (Integer)1, clazz);
    }

    public static <T> T getT1(Envelop envelop, Class<T> clazz) {
        return In.request(envelop, (Integer)1, clazz);
    }

    public static <T> T getT2(Message<Envelop> message, Class<T> clazz) {
        return In.request(message, (Integer)2, clazz);
    }

    public static <T> T getT2(Envelop envelop, Class<T> clazz) {
        return In.request(envelop, (Integer)2, clazz);
    }

    public static <T> T getT3(Message<Envelop> message, Class<T> clazz) {
        return In.request(message, (Integer)3, clazz);
    }

    public static <T> T getT3(Envelop envelop, Class<T> clazz) {
        return In.request(envelop, (Integer)3, clazz);
    }

    public static JsonObject getBody(Message<Envelop> message) {
        return In.request(message, JsonObject.class);
    }

    public static <T> T getBodyT(Message<Envelop> message, Class<T> clazz) {
        return In.request(message, clazz);
    }

    public static <T> Future<JsonObject> thenRpc(String name, String address, JsonObject params) {
        return UxRpc.thenRpc(name, address, params);
    }

    public static <T> Future<JsonObject> thenRpc(String name, String address, String field, Object value) {
        return UxRpc.thenRpc(name, address, new JsonObject().put(field, value));
    }

    public static <T> Future<JsonArray> thenJsonMore(List<T> list) {
        return Future.succeededFuture((Object)To.toArray(list, ""));
    }

    public static <T> Future<JsonArray> thenJsonMore(List<T> list, String pojo) {
        return Future.succeededFuture((Object)To.toArray(list, pojo));
    }

    public static <T> Future<JsonObject> thenJsonOne(List<T> list, String pojo) {
        return Future.succeededFuture((Object)To.toUnique(new JsonArray(list), pojo));
    }

    public static <T> Future<JsonObject> thenJsonOne(T entity, String pojo) {
        return Future.succeededFuture((Object)To.toJson(entity, pojo));
    }

    public static <T> Future<Envelop> thenMore(List<T> list, String pojo) {
        return Future.succeededFuture((Object)Envelop.success(To.toArray(list, pojo)));
    }

    public static <T> Future<Envelop> thenOne(T entity, String pojo) {
        return Future.succeededFuture((Object)Envelop.success(To.toJson(entity, pojo)));
    }

    public static <T> Future<T> thenGeneric(Consumer<Future<T>> consumer) {
        return Wait.then(consumer);
    }

    public static <F, S, T> Future<List<T>> thenParallel(Future<List<F>> source, Function<F, Future<S>> generateFun, BiFunction<F, S, T> mergeFun) {
        return Fluctuate.thenParallel(source, generateFun, mergeFun);
    }

    public static Future<JsonArray> thenParallelArray(Future<JsonArray> source, Function<JsonObject, Future<JsonObject>> generateFun, BinaryOperator<JsonObject> operatorFun) {
        return Fluctuate.thenParallelArray(source, generateFun, operatorFun);
    }

    public static Future<JsonObject> thenParallelArray(Future<JsonArray> ... sources) {
        return Fluctuate.thenParallelArray(sources);
    }

    public static Future<JsonObject> thenParallelJson(Future<JsonObject> ... sources) {
        return Fluctuate.thenParallelJson(sources);
    }

    public static Future<JsonObject> thenParallelJson(Future<JsonObject> source, Function<JsonObject, List<Future>> generateFun, BiConsumer<JsonObject, JsonObject> ... operatorFun) {
        return Fluctuate.thenParallelJson(source, generateFun, operatorFun);
    }

    public static Future<JsonObject> thenParallelJson(JsonObject source, Function<JsonObject, List<Future>> generateFun, BiConsumer<JsonObject, JsonObject> ... operatorFun) {
        return Fluctuate.thenParallelJson((Future<JsonObject>)Future.succeededFuture((Object)source), generateFun, operatorFun);
    }

    public static Future<JsonArray> thenScatterJson(Future<JsonArray> source, Function<JsonObject, Future<JsonArray>> generateFun, BiFunction<JsonObject, JsonArray, JsonObject> mergeFun) {
        return Fluctuate.thenScatterJson(source, generateFun, mergeFun);
    }

    public static <F, S, T> Future<T> thenComposite(Future<F> source, BiFunction<F, List<S>, T> mergeFun, Supplier<Future<S>> ... suppliers) {
        return Fluctuate.thenComposite(source, mergeFun, suppliers);
    }

    public static <F, S, T> Future<T> thenComposite(Future<F> source, BiFunction<F, List<S>, T> mergeFun, Function<F, Future<S>> ... functions) {
        return Fluctuate.thenComposite(source, mergeFun, functions);
    }

    public static <T, F, R> Future<R> thenOtherwise(Future<Boolean> condition, Supplier<Future<T>> trueFuture, Function<T, R> trueFun, Supplier<Future<F>> falseFuture, Function<F, R> falseFun) {
        return Fluctuate.thenOtherwise(condition, trueFuture, trueFun, falseFuture, falseFun);
    }

    public static <T, R> Future<R> thenError(Future<Boolean> condition, Supplier<Future<T>> trueFuture, Function<T, R> trueFun, Class<? extends WebException> clazz, Object ... args) {
        return Fluctuate.thenOtherwise(condition, trueFuture, trueFun, clazz, args);
    }

    public static Future<JsonObject> thenError(Future<Boolean> condition, Supplier<Future<JsonObject>> trueFuture, Class<? extends WebException> clazz, Object ... args) {
        return Fluctuate.thenOtherwise(condition, trueFuture, (T item) -> item, clazz, args);
    }

    public static <T> Future<T> thenError(Class<? extends WebException> clazz, Object ... args) {
        return Fluctuate.thenError(clazz, args);
    }

    public static <T, R> Future<R> thenTrue(Future<Boolean> condition, Supplier<Future<T>> trueFuture, Function<T, R> trueFun) {
        return Fluctuate.thenOtherwise(condition, trueFuture, trueFun, null, new Object[0]);
    }

    public static class Mongo {
        public static JsonObject termIn(JsonObject filter, String field, JsonArray values) {
            return UxMongo.termIn(filter, field, values);
        }

        public static JsonObject termLike(JsonObject filter, String field, String value) {
            return UxMongo.termLike(filter, field, value);
        }

        public static Future<Boolean> missing(String collection, JsonObject filter) {
            return UxMongo.missing(collection, filter);
        }

        public static Future<Boolean> existing(String collection, JsonObject filter) {
            return UxMongo.existing(collection, filter);
        }

        public static Future<JsonObject> insert(String collection, JsonObject data) {
            return UxMongo.insert(collection, data);
        }

        public static Future<JsonObject> findOne(String collection, JsonObject filter) {
            return UxMongo.findOne(collection, filter);
        }

        public static Future<JsonObject> findOne(String collection, JsonObject filter, String joinedCollection, String joinedKey, JsonObject additional, BinaryOperator<JsonObject> operatorFun) {
            return UxMongo.findOne(collection, filter, joinedCollection, joinedKey, additional, operatorFun);
        }

        public static Future<JsonObject> findOneAndReplace(String collection, JsonObject filter, String field, Object value) {
            return UxMongo.findOneAndReplace(collection, filter, new JsonObject().put(field, value));
        }

        public static Future<JsonObject> findOneAndReplace(String collection, JsonObject filter, JsonObject data) {
            return UxMongo.findOneAndReplace(collection, filter, data);
        }

        public static Future<Long> removeDocument(String collection, JsonObject filter) {
            return UxMongo.removeDocument(collection, filter);
        }

        public static Future<JsonArray> findWithOptions(String collection, JsonObject filter, FindOptions options) {
            return UxMongo.findWithOptions(collection, filter, options);
        }

        public static Future<JsonArray> findWithOptions(String collection, JsonObject filter, FindOptions options, String joinedCollection, String joinedKey, JsonObject additional, BinaryOperator<JsonObject> operatorFun) {
            return UxMongo.findWithOptions(collection, filter, options, joinedCollection, joinedKey, additional, operatorFun);
        }

        public static Future<JsonArray> find(String collection, JsonObject filter) {
            return UxMongo.findWithOptions(collection, filter, new FindOptions());
        }
    }

    public static class Jooq {
        public static UxJooq on(Class<?> clazz) {
            return (UxJooq)Fn.pool(Pool.JOOQ, clazz, () -> new UxJooq(clazz));
        }
    }
}

