/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.web.origin;

import io.reactivex.Observable;
import io.vertx.up.annotations.Ipc;
import io.vertx.up.atom.Envelop;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.StringUtil;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.up.tool.mirror.Types;
import io.vertx.up.web.origin.Inquirer;
import io.vertx.zero.exception.IpcMethodArgException;
import io.vertx.zero.exception.IpcMethodReturnException;
import io.vertx.zero.exception.IpcMethodTargetException;
import io.vertx.zero.exception.UnknownDirectionException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class IpcInquirer
implements Inquirer<ConcurrentMap<String, Method>> {
    private static final Annal LOGGER = Annal.get(IpcInquirer.class);

    @Override
    public ConcurrentMap<String, Method> scan(Set<Class<?>> classes) {
        ConcurrentHashMap<String, Method> addresses = new ConcurrentHashMap<String, Method>();
        Observable.fromIterable(classes).flatMap(clazz -> Observable.fromArray((Object[])clazz.getDeclaredMethods())).filter(Objects::nonNull).filter(method -> method.isAnnotationPresent(Ipc.class)).map(this::ensureTarget).map(this::ensureSpec).subscribe(method -> {
            Ipc annotation = method.getAnnotation(Ipc.class);
            String address = (String)Instance.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
            addresses.put(address, (Method)method);
        });
        return addresses;
    }

    private Method ensureSpec(Method method) {
        Fn.flingUp((boolean)Types.isVoid(method.getReturnType()), (Annal)LOGGER, IpcMethodReturnException.class, (Object[])new Object[]{this.getClass(), method});
        Ipc annotation = method.getAnnotation(Ipc.class);
        String value = (String)Instance.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
        if (!StringUtil.isNil((String)value)) {
            Class<?>[] argTypes = method.getParameterTypes();
            Fn.flingUp((1 != argTypes.length || Envelop.class != argTypes[0] ? 1 : 0) != 0, (Annal)LOGGER, IpcMethodArgException.class, (Object[])new Object[]{this.getClass(), method});
        }
        return method;
    }

    private Method ensureTarget(Method method) {
        Ipc annotation = method.getAnnotation(Ipc.class);
        String to = (String)Instance.invoke((Object)annotation, (String)"to", (Object[])new Object[0]);
        String name = (String)Instance.invoke((Object)annotation, (String)"name", (Object[])new Object[0]);
        if (StringUtil.isNil((String)to) && StringUtil.isNil((String)name)) {
            String from = (String)Instance.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
            Fn.flingUp((boolean)StringUtil.isNil((String)from), (Annal)LOGGER, UnknownDirectionException.class, (Object[])new Object[]{this.getClass(), method});
            return method;
        }
        Fn.flingUp((StringUtil.isNil((String)to) || StringUtil.isNil((String)name) ? 1 : 0) != 0, (Annal)LOGGER, IpcMethodTargetException.class, (Object[])new Object[]{this.getClass(), method, to, name});
        return method;
    }
}

