/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.rs.hunt;

import io.reactivex.Observable;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.Rule;
import io.vertx.up.atom.agent.Depot;
import io.vertx.up.atom.agent.Event;
import io.vertx.up.exception._400ValidationException;
import io.vertx.up.func.Fn;
import io.vertx.up.web.ZeroCodex;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.executable.ExecutableValidator;
import javax.ws.rs.BodyParam;

public class Validator {
    private static final javax.validation.Validator VALIDATOR = Validation.buildDefaultValidatorFactory().getValidator();
    private static final ConcurrentMap<String, Map<String, List<Rule>>> RULERS = new ConcurrentHashMap<String, Map<String, List<Rule>>>();
    private static Validator INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Validator create() {
        if (null != INSTANCE) return INSTANCE;
        Class<Validator> clazz = Validator.class;
        synchronized (Validator.class) {
            if (null != INSTANCE) return INSTANCE;
            INSTANCE = new Validator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public <T> void verifyMethod(T proxy, Method method, Object[] args) {
        ConstraintViolation item;
        ExecutableValidator validatorParam = VALIDATOR.forExecutables();
        Set constraints = validatorParam.validateParameters(proxy, method, args, new Class[0]);
        if (!constraints.isEmpty() && null != (item = (ConstraintViolation)constraints.iterator().next())) {
            _400ValidationException error = new _400ValidationException(this.getClass(), proxy.getClass(), method, item.getMessage());
            error.setReadible(item.getMessage());
            throw error;
        }
    }

    public Map<String, List<Rule>> buildRulers(Depot depot) {
        LinkedHashMap<String, List<Rule>> rulers = new LinkedHashMap<String, List<Rule>>();
        ConcurrentMap<String, Class<? extends Annotation>> annotions = depot.getAnnotations();
        Observable.fromIterable(annotions.keySet()).filter("$$DIRECT$$"::equals).map(annotions::get).any(item -> BodyParam.class == item).map(item -> this.buildKey(depot.getEvent())).map(this::buildRulers).subscribe(rulers::putAll);
        return rulers;
    }

    private Map<String, List<Rule>> buildRulers(String key) {
        if (RULERS.containsKey(key)) {
            return (Map)RULERS.get(key);
        }
        JsonObject rule = ZeroCodex.getCodex(key);
        LinkedHashMap<String, List<Rule>> ruler = new LinkedHashMap<String, List<Rule>>();
        if (null != rule) {
            Fn.itJObject((JsonObject)rule, (value, field) -> {
                List<Rule> rulers = this.buildRulers(value);
                if (!rulers.isEmpty()) {
                    ruler.put((String)field, rulers);
                }
            });
            if (!ruler.isEmpty()) {
                RULERS.put(key, ruler);
            }
        }
        return ruler;
    }

    private List<Rule> buildRulers(Object config) {
        ArrayList<Rule> rulers = new ArrayList<Rule>();
        if (null != config && config instanceof JsonArray) {
            JsonArray configData = (JsonArray)config;
            Fn.itJArray((JsonArray)configData, JsonObject.class, (item, index) -> {
                Rule ruler = Rule.create(item);
                if (null != ruler) {
                    rulers.add(ruler);
                }
            });
        }
        return rulers;
    }

    private String buildKey(Event event) {
        String prefix = event.getPath().trim().substring(1);
        prefix = prefix.replace("/", ".");
        String suffix = event.getMethod().name().toLowerCase(Locale.getDefault());
        return prefix + "." + suffix;
    }
}

