/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.rs.hunt;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.up.atom.Envelop;
import io.vertx.up.atom.Rule;
import io.vertx.up.atom.agent.Depot;
import io.vertx.up.atom.agent.Event;
import io.vertx.up.atom.hold.Virtual;
import io.vertx.up.exception.WebException;
import io.vertx.up.rs.hunt.Answer;
import io.vertx.up.rs.hunt.Validator;
import io.vertx.up.rs.regular.Ruler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

class Flower {
    Flower() {
    }

    static <T> Envelop continuous(RoutingContext context, T entity) {
        Envelop envelop = Envelop.success(entity);
        envelop.setHeaders(context.request().headers());
        envelop.setUser(context.user());
        return envelop;
    }

    static void executeRequest(RoutingContext context, Map<String, List<Rule>> rulers, Depot depot, Object[] args, Validator verifier) {
        WebException error = Flower.verifyPureArguments(verifier, depot, args);
        if (null == error) {
            error = Flower.verifyBody(rulers, args);
            if (null == error) {
                context.next();
            } else {
                Flower.replyError(context, error, depot.getEvent());
            }
        } else {
            Flower.replyError(context, error, depot.getEvent());
        }
    }

    private static void replyError(RoutingContext context, WebException error, Event event) {
        Envelop envelop = Envelop.failure(error);
        Answer.reply(context, envelop, event);
    }

    private static WebException verifyBody(Map<String, List<Rule>> rulers, Object[] args) {
        Object body;
        WebException error = null;
        if (!rulers.isEmpty() && null != (body = args[0])) {
            JsonObject data = (JsonObject)body;
            error = Flower.verifyBody(rulers, data);
        }
        return error;
    }

    private static WebException verifyBody(Map<String, List<Rule>> rulers, JsonObject data) {
        WebException error = null;
        block0: for (String field : rulers.keySet()) {
            Object value = data.getValue(field);
            List<Rule> rules = rulers.get(field);
            for (Rule rule : rules) {
                Ruler ruler = Ruler.get(rule.getType());
                if (null != ruler) {
                    error = ruler.verify(field, value, rule);
                }
                if (null == error) continue;
                break block0;
            }
        }
        return error;
    }

    private static WebException verifyPureArguments(Validator verifier, Depot depot, Object[] args) {
        Event event = depot.getEvent();
        Object proxy = event.getProxy();
        Method method = event.getAction();
        WebException error = null;
        try {
            if (!Virtual.is(proxy)) {
                verifier.verifyMethod(proxy, method, args);
            }
        }
        catch (WebException ex) {
            error = ex;
        }
        return error;
    }
}

