/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.rs.hunt;

import io.vertx.core.AsyncResult;
import io.vertx.core.eventbus.Message;
import io.vertx.ext.web.RoutingContext;
import io.vertx.up.annotations.Address;
import io.vertx.up.atom.Envelop;
import io.vertx.up.atom.Rule;
import io.vertx.up.atom.agent.Depot;
import io.vertx.up.atom.agent.Event;
import io.vertx.up.exception._500DeliveryErrorException;
import io.vertx.up.exception._500EntityCastException;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.media.Analyzer;
import io.vertx.up.media.MediaAnalyzer;
import io.vertx.up.rs.hunt.Flower;
import io.vertx.up.rs.hunt.Validator;
import io.vertx.up.tool.StringUtil;
import io.vertx.up.tool.mirror.Instance;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public abstract class BaseAim {
    private final transient Validator verifier = Validator.create();
    private final transient Analyzer analyzer = (Analyzer)Instance.singleton(MediaAnalyzer.class, (Object[])new Object[0]);

    protected Object[] buildArgs(RoutingContext context, Event event) {
        Object[] cached = (Object[])context.get("$$PARAM$$");
        if (null == cached) {
            cached = (Object[])this.analyzer.in(context, event);
            context.put("$$PARAM$$", (Object)cached);
        }
        return cached;
    }

    protected String address(Event event) {
        Method method = event.getAction();
        Address annotation = method.getDeclaredAnnotation(Address.class);
        return (String)Instance.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
    }

    protected Object invoke(Event event, Object[] args) {
        Method method = event.getAction();
        this.getLogger().info("[ ZERO-DEBUG ] Method = {0}, Args = {1}", new Object[]{method.getName(), StringUtil.join((Object[])args)});
        return Instance.invoke((Object)event.getProxy(), (String)method.getName(), (Object[])args);
    }

    protected Envelop failure(String address, AsyncResult<Message<Envelop>> handler) {
        _500DeliveryErrorException error = new _500DeliveryErrorException(this.getClass(), address, (String)Fn.get(null, () -> handler.cause().getMessage(), (Object[])new Object[]{handler.cause()}));
        return Envelop.failure(error);
    }

    protected Envelop success(String address, AsyncResult<Message<Envelop>> handler) {
        Envelop envelop;
        try {
            Message message = (Message)handler.result();
            envelop = (Envelop)message.body();
        }
        catch (Throwable ex) {
            _500EntityCastException error = new _500EntityCastException(this.getClass(), address, ex.getMessage());
            envelop = Envelop.failure(error);
        }
        return envelop;
    }

    protected Validator verifier() {
        return this.verifier;
    }

    protected Annal getLogger() {
        return Annal.get(this.getClass());
    }

    protected void executeRequest(RoutingContext context, Map<String, List<Rule>> rulers, Depot depot) {
        Object[] args = this.buildArgs(context, depot.getEvent());
        Flower.executeRequest(context, rulers, depot, args, this.verifier());
    }
}

