/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.rs.config;

import io.reactivex.Observable;
import io.vertx.up.annotations.Address;
import io.vertx.up.atom.worker.Receipt;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.rs.Extractor;
import io.vertx.up.tool.mirror.Anno;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.up.web.ZeroAnno;
import io.vertx.zero.exception.AccessProxyException;
import io.vertx.zero.exception.AddressWrongException;
import io.vertx.zero.exception.NoArgConstructorException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class ReceiptExtractor
implements Extractor<Set<Receipt>> {
    private static final Annal LOGGER = Annal.get(ReceiptExtractor.class);
    private static final Set<String> ADDRESS = new TreeSet<String>();

    @Override
    public Set<Receipt> extract(Class<?> clazz) {
        return (Set)Fn.get(new HashSet(), () -> {
            this.verify(clazz);
            HashSet receipts = new HashSet();
            Object[] methods = clazz.getDeclaredMethods();
            Observable.fromArray((Object[])methods).filter(method -> method.isAnnotationPresent(Address.class)).map(this::extract).filter(Objects::nonNull).subscribe(receipts::add);
            return receipts;
        }, (Object[])new Object[]{clazz});
    }

    private Receipt extract(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        Address annotation = method.getDeclaredAnnotation(Address.class);
        String address = (String)Instance.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
        Fn.flingUp((!ADDRESS.contains(address) ? 1 : 0) != 0, (Annal)LOGGER, AddressWrongException.class, (Object[])new Object[]{this.getClass(), address, clazz, method});
        Receipt receipt = new Receipt();
        receipt.setMethod(method);
        receipt.setAddress(address);
        Object proxy = Instance.singleton(clazz, (Object[])new Object[0]);
        receipt.setProxy(proxy);
        return receipt;
    }

    private void verify(Class<?> clazz) {
        Fn.flingUp((!Instance.noarg(clazz) ? 1 : 0) != 0, (Annal)LOGGER, NoArgConstructorException.class, (Object[])new Object[]{this.getClass(), clazz});
        Fn.flingUp((!Modifier.isPublic(clazz.getModifiers()) ? 1 : 0) != 0, (Annal)LOGGER, AccessProxyException.class, (Object[])new Object[]{this.getClass(), clazz});
    }

    static {
        if (ADDRESS.isEmpty()) {
            Set<Class<?>> queues = ZeroAnno.getEndpoints();
            Observable.fromIterable(queues).map(queue -> Anno.query((Class)queue, Address.class)).subscribe(annotations -> Observable.fromArray((Object[])annotations).map(addressAnno -> Instance.invoke((Object)addressAnno, (String)"value", (Object[])new Object[0])).filter(Objects::nonNull).subscribe(address -> ADDRESS.add(address.toString())));
        }
        LOGGER.info("[ ZERO ] Vert.x zero has found {0} incoming address from the system. Incoming address list as below: ", new Object[]{ADDRESS.size()});
        ADDRESS.forEach(item -> LOGGER.info("[ ZERO ]        Addr : {0}", new Object[]{item}));
    }
}

