/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.plugin.mongo;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.up.concurrent.Runner;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.StringUtil;
import io.vertx.zero.exception.XtorConnectException;
import io.vertx.zero.exception.XtorExecuteException;
import io.vertx.zero.exception.XtorNotReadyException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiFunction;
import java.util.function.Function;

public class MongoWtor {
    private static final Annal LOGGER = Annal.get(MongoWtor.class);
    private final transient MongoClient client;
    private transient Class<?> hitted;
    private transient Annal logger;
    private transient String collection;
    private transient UpdateOptions option;
    private transient Function aggregate;

    public static MongoWtor init(MongoClient client) {
        return new MongoWtor(client);
    }

    private MongoWtor(MongoClient client) {
        Fn.flingUp((null == client ? 1 : 0) != 0, (Annal)LOGGER, XtorConnectException.class, (Object[])new Object[]{this.getClass(), "client = " + client, "constructor(MongoClient)"});
        this.client = client;
    }

    @Fluent
    public MongoWtor connect(Class<?> clazz) {
        Fn.flingUp((null == clazz ? 1 : 0) != 0, (Annal)LOGGER, XtorConnectException.class, (Object[])new Object[]{this.getClass(), "hitted = " + clazz, "connect(Class)"});
        this.hitted = clazz;
        this.logger = null == clazz ? Annal.get(MongoWtor.class) : Annal.get(clazz);
        return this;
    }

    @Fluent
    public MongoWtor connect(String collection) {
        Fn.flingUp((boolean)StringUtil.isNil((String)collection), (Annal)LOGGER, XtorConnectException.class, (Object[])new Object[]{this.getClass(), "collection = " + collection, "connect(String)"});
        this.collection = collection;
        return this;
    }

    @Fluent
    public MongoWtor connect(UpdateOptions option) {
        this.option = option;
        return this;
    }

    @Fluent
    public <T, R> MongoWtor connect(Function<T, R> aggregate) {
        if (null != aggregate) {
            this.aggregate = aggregate;
        }
        return this;
    }

    public JsonObject decreaseBy(JsonObject condition, String field, int step) {
        return this.execute(condition, field, this.decrease(step));
    }

    public JsonObject decreaseBy(JsonObject condition, String field) {
        return this.execute(condition, field, this.decrease(1));
    }

    public JsonObject increaseBy(JsonObject condition, String field, int step) {
        return this.execute(condition, field, this.increase(step));
    }

    public JsonObject increaseBy(JsonObject condition, String field) {
        return this.execute(condition, field, this.increase(1));
    }

    public JsonObject write(JsonObject condition, JsonObject latest, ConcurrentMap<String, BiFunction<Object, Object, Object>> itemFuns) {
        this.ensure();
        return (JsonObject)Fn.getJvm((Object)new JsonObject(), () -> {
            CountDownLatch counter = new CountDownLatch(1);
            JsonObject data = new JsonObject();
            Runner.run(() -> {
                this.logger.debug("[ ZERO ] Mongo collection = {0}, filter: {1}, data: {2}", new Object[]{this.collection, condition, latest});
                if (itemFuns.isEmpty()) {
                    this.logger.info("[ ZERO ] Mongo update flow = {0}, filter: {1}, latest: {2}", new Object[]{"( Pure Update )", condition, latest});
                    this.client.findOneAndUpdate(this.collection, condition, latest, res -> {
                        if (res.succeeded()) {
                            data.mergeIn((JsonObject)res.result());
                        } else {
                            Fn.flingUp((boolean)true, (Annal)LOGGER, XtorExecuteException.class, (Object[])new Object[]{this.getClass(), this.cause(res.cause())});
                        }
                        counter.countDown();
                    });
                } else {
                    this.client.findOne(this.collection, condition, null, res -> {
                        if (res.succeeded()) {
                            JsonObject oldData = (JsonObject)res.result();
                            this.logger.debug("[ ZERO ] Mongo collection = {0}, query by: {1}, data: {2}", new Object[]{this.collection, condition, oldData});
                            JsonObject newData = new JsonObject();
                            if (null != oldData) {
                                for (String field : oldData.fieldNames()) {
                                    Object value = oldData.getValue(field);
                                    if (itemFuns.containsKey(field)) {
                                        BiFunction fun = (BiFunction)itemFuns.get(field);
                                        Object oldValue = oldData.getValue(field);
                                        value = fun.apply(oldValue, value);
                                    } else if (latest.containsKey(field)) {
                                        value = latest.getValue(field);
                                    }
                                    newData.put(field, value);
                                }
                                this.logger.info("[ ZERO ] Mongo update flow = {0}, filter: {1}, latest: {2}", new Object[]{"( Complex Update )", condition, newData});
                                this.client.findOneAndReplace(this.collection, condition, newData, inner -> {
                                    if (inner.succeeded()) {
                                        data.mergeIn((JsonObject)inner.result());
                                    } else {
                                        Fn.flingUp((boolean)true, (Annal)LOGGER, XtorExecuteException.class, (Object[])new Object[]{this.getClass(), this.cause(res.cause())});
                                    }
                                    counter.countDown();
                                });
                            } else {
                                counter.countDown();
                            }
                        } else {
                            Fn.flingUp((boolean)true, (Annal)LOGGER, XtorExecuteException.class, (Object[])new Object[]{this.getClass(), this.cause(res.cause())});
                            counter.countDown();
                        }
                    });
                }
            }, (String)"concurrent-update");
            return data;
        }, (Object[])new Object[]{itemFuns, condition, latest});
    }

    private String cause(Throwable error) {
        return null != error ? error.getMessage() : "";
    }

    private void ensure() {
        Fn.flingUp((null == this.client || null == this.collection || null == this.hitted || null == this.logger ? 1 : 0) != 0, (Annal)LOGGER, XtorNotReadyException.class, (Object[])new Object[]{this.getClass()});
    }

    private JsonObject execute(JsonObject condition, final String field, final BiFunction<Object, Object, Object> func) {
        ConcurrentHashMap<String, BiFunction<Object, Object, Object>> funcMap = new ConcurrentHashMap<String, BiFunction<Object, Object, Object>>(){
            {
                this.put(field, func);
            }
        };
        return this.write(condition, new JsonObject(), (ConcurrentMap<String, BiFunction<Object, Object, Object>>)funcMap);
    }

    private BiFunction<Object, Object, Object> increase(int step) {
        return (oldVal, newVale) -> (Integer)Fn.getJvm((Object)0, () -> Integer.parseInt(oldVal.toString()) + step, (Object[])new Object[]{oldVal});
    }

    private BiFunction<Object, Object, Object> decrease(int step) {
        return (oldVal, newValue) -> (Integer)Fn.getJvm((Object)0, () -> Integer.parseInt(oldVal.toString()) - 1, (Object[])new Object[]{oldVal});
    }
}

