/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.plugin.mongo;

import io.reactivex.Observable;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.up.atom.Envelop;
import io.vertx.up.concurrent.Runner;
import io.vertx.up.func.Fn;
import io.vertx.up.kidd.outcome.ListObstain;
import io.vertx.up.log.Annal;
import io.vertx.up.plugin.mongo.MongoWtor;
import io.vertx.up.tool.Jackson;
import io.vertx.up.tool.StringUtil;
import io.vertx.zero.exception.XtorConnectException;
import io.vertx.zero.exception.XtorExecuteException;
import io.vertx.zero.exception.XtorNotReadyException;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;

public class MongoRtor {
    private static final Annal LOGGER = Annal.get(MongoRtor.class);
    private final transient MongoClient client;
    private transient Class<?> hitted;
    private transient Annal logger;
    private transient String collection;
    private transient FindOptions options = new FindOptions();
    private transient Function aggregate = item -> item;
    private final transient JsonObject filter = new JsonObject();

    public static MongoRtor init(MongoClient client) {
        return new MongoRtor(client);
    }

    private MongoRtor(MongoClient client) {
        Fn.flingUp((null == client ? 1 : 0) != 0, (Annal)LOGGER, XtorConnectException.class, (Object[])new Object[]{this.getClass(), "client = " + client, "constructor(MongoClient)"});
        this.client = client;
    }

    @Fluent
    public MongoRtor connect(Class<?> clazz) {
        Fn.flingUp((null == clazz ? 1 : 0) != 0, (Annal)LOGGER, XtorConnectException.class, (Object[])new Object[]{this.getClass(), "hitted = " + clazz, "connect(Class)"});
        this.hitted = clazz;
        this.logger = null == clazz ? Annal.get(MongoWtor.class) : Annal.get(clazz);
        return this;
    }

    @Fluent
    public MongoRtor connect(String collection) {
        Fn.flingUp((boolean)StringUtil.isNil((String)collection), (Annal)LOGGER, XtorConnectException.class, (Object[])new Object[]{this.getClass(), "collection = " + collection, "connect(String)"});
        this.collection = collection;
        return this;
    }

    @Fluent
    public MongoRtor connect(FindOptions options) {
        if (null != options) {
            this.options = options;
        }
        return this;
    }

    @Fluent
    public MongoRtor connect(JsonObject filter) {
        if (null != filter) {
            this.filter.mergeIn(filter);
        }
        return this;
    }

    @Fluent
    public <T, R> MongoRtor connect(Function<T, R> aggregate) {
        if (null != aggregate) {
            this.aggregate = aggregate;
        }
        return this;
    }

    public JsonObject read(JsonObject dataObject, String refKey, String verticalKey, String mountField) {
        return this.read(dataObject, refKey, verticalKey, mountField, true);
    }

    public JsonObject read(JsonObject dataObject, String refKey, String verticalKey, String mountField, boolean unique) {
        JsonArray dataArray = new JsonArray().add(dataObject);
        this.read(dataArray, refKey, verticalKey, mountField, unique);
        return dataArray.getJsonObject(0);
    }

    public JsonArray read(JsonArray dataArray, String refKey, String verticalKey) {
        this.ensure();
        return (JsonArray)Fn.getJvm((Object)new JsonArray(), () -> {
            JsonArray ids = new JsonArray();
            Observable.fromIterable((Iterable)dataArray).filter(Objects::nonNull).map(item -> (JsonObject)item).filter(item -> item.containsKey(verticalKey)).map(item -> item.getValue(verticalKey)).subscribe(arg_0 -> ((JsonArray)ids).add(arg_0));
            CountDownLatch counter = new CountDownLatch(1);
            JsonArray result = new JsonArray();
            Runner.run(() -> {
                JsonObject filter = new JsonObject().put(refKey, new JsonObject().put("$in", ids));
                filter.mergeIn(this.filter);
                this.logger.info("[ ZERO ] Mongo collection = {0}, filter: {1}", new Object[]{this.collection, filter});
                this.client.findWithOptions(this.collection, filter, new FindOptions(), res -> {
                    if (res.succeeded()) {
                        Envelop envelop = ((ListObstain)ListObstain.startList(this.hitted).connect((AsyncResult)res)).result().to();
                        JsonArray data = (JsonArray)envelop.data();
                        this.logger.info("[ ZERO ] Merged {0} and {1}, sourceKey = {2}, targetKey = {3}", new Object[]{dataArray, data, verticalKey, refKey});
                        JsonArray merged = Jackson.mergeZip((JsonArray)dataArray, (JsonArray)data, (String)verticalKey, (String)refKey);
                        result.addAll(merged);
                    } else {
                        Fn.flingUp((boolean)true, (Annal)LOGGER, XtorExecuteException.class, (Object[])new Object[]{this.getClass(), this.cause(res.cause())});
                    }
                    counter.countDown();
                });
            }, (String)"concurrent-secondary-flip");
            try {
                counter.await();
            }
            catch (InterruptedException ex) {
                this.logger.jvm((Throwable)ex);
            }
            return result;
        }, (Object[])new Object[]{refKey, verticalKey});
    }

    public JsonArray read(JsonArray dataArray, String refKey, String verticalKey, String mountField) {
        return this.read(dataArray, refKey, verticalKey, mountField, false);
    }

    public JsonArray read(JsonArray dataArray, String refKey, String verticalKey, String mountField, boolean unique) {
        this.ensure();
        return (JsonArray)Fn.getJvm((Object)new JsonArray(), () -> {
            CountDownLatch counter = new CountDownLatch(dataArray.size());
            Fn.itJArray((JsonArray)dataArray, JsonObject.class, (item, index) -> {
                Object value = item.getValue(verticalKey);
                Fn.safeNull(() -> Runner.run(() -> {
                    JsonObject filter = new JsonObject().put(refKey, value);
                    filter.mergeIn(this.filter);
                    this.logger.info("[ ZERO ] Mongo collection = {0}, filter: {1}", new Object[]{this.collection, filter});
                    this.client.findWithOptions(this.collection, filter, this.options, res -> {
                        if (res.succeeded()) {
                            Envelop envelop = ((ListObstain)ListObstain.startList(this.hitted).connect((AsyncResult)res)).result().to();
                            JsonArray data = (JsonArray)envelop.data();
                            if (null != data) {
                                if (unique) {
                                    JsonObject replaced = data.getJsonObject(0);
                                    item.put(mountField, this.aggregate.apply(replaced));
                                } else {
                                    item.put(mountField, this.aggregate.apply(data));
                                }
                            }
                        } else {
                            Fn.flingUp((boolean)true, (Annal)LOGGER, XtorExecuteException.class, (Object[])new Object[]{this.getClass(), this.cause(res.cause())});
                        }
                        counter.countDown();
                    });
                }, (String)("concurrent-secondary-" + value)), (Object[])new Object[]{value});
            });
            try {
                counter.await();
            }
            catch (InterruptedException ex) {
                this.logger.jvm((Throwable)ex);
            }
            return dataArray;
        }, (Object[])new Object[]{refKey, verticalKey, mountField});
    }

    private String cause(Throwable error) {
        return null != error ? error.getMessage() : "";
    }

    private void ensure() {
        Fn.flingUp((null == this.client || null == this.collection || null == this.hitted || null == this.logger ? 1 : 0) != 0, (Annal)LOGGER, XtorNotReadyException.class, (Object[])new Object[]{this.getClass()});
    }
}

