/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.plugin.mongo;

import io.vertx.ext.mongo.FindOptions;
import io.vertx.up.atom.query.Pager;
import io.vertx.up.atom.query.Sorter;
import io.vertx.up.func.Fn;

public class MongoReadOpts {
    public static FindOptions toDescLimit(String sortField, int limit) {
        return MongoReadOpts.toFull(Pager.create(1, limit), Sorter.create(sortField, false));
    }

    public static FindOptions toAscLimit(String sortField, int limit) {
        return MongoReadOpts.toFull(Pager.create(1, limit), Sorter.create(sortField, true));
    }

    public static FindOptions toDesc(String sortField) {
        return MongoReadOpts.toFull(null, Sorter.create(sortField, false));
    }

    public static FindOptions toAsc(String sortField) {
        return MongoReadOpts.toFull(null, Sorter.create(sortField, true));
    }

    public static FindOptions toFull(Pager pager, Sorter sorter) {
        FindOptions options = new FindOptions();
        Fn.safeNull(() -> {
            options.setLimit(pager.getSize());
            options.setSkip(pager.getStart());
        }, (Object[])new Object[]{pager});
        Fn.safeNull(() -> options.setSort(sorter.toJson(mode -> mode != false ? 1 : -1)), (Object[])new Object[]{sorter});
        return options;
    }
}

