/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro.ipc.server;

import io.grpc.BindableService;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.tp.ipc.eon.IpcRequest;
import io.vertx.tp.ipc.eon.IpcResponse;
import io.vertx.tp.ipc.service.UnityServiceGrpc;
import io.vertx.up.annotations.Ipc;
import io.vertx.up.atom.Envelop;
import io.vertx.up.atom.flux.IpcData;
import io.vertx.up.eon.em.IpcType;
import io.vertx.up.exception._501RpcMethodMissingException;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.ipc.DataEncap;
import io.vertx.up.micro.ipc.server.Tunnel;
import io.vertx.up.micro.ipc.tower.FinalTransit;
import io.vertx.up.micro.ipc.tower.NodeTransit;
import io.vertx.up.micro.ipc.tower.Transit;
import io.vertx.up.tool.StringUtil;
import io.vertx.up.tool.mirror.Instance;
import java.lang.reflect.Method;

public class UnityTunnel
implements Tunnel {
    private static final Annal LOGGER = Annal.get(UnityTunnel.class);

    @Override
    public BindableService init(Vertx vertx) {
        return new UnityServiceGrpc.UnityServiceVertxImplBase(){

            public void unityCall(IpcRequest request, Future<IpcResponse> future) {
                IpcData data = DataEncap.consume(request, IpcType.UNITY);
                Method method = (Method)Tunnel.IPCS.get(data.getAddress());
                if (null == method) {
                    Envelop envelop = Envelop.failure(new _501RpcMethodMissingException(((Object)((Object)this)).getClass(), data.getAddress()));
                } else {
                    Envelop envelop = DataEncap.consume(data);
                    Transit transit = UnityTunnel.this.getTransit(method);
                    Future<Envelop> result = transit.async(envelop);
                    Envelop community = (Envelop)result.result();
                    IpcData responseData = UnityTunnel.this.build(community, envelop);
                    future.complete((Object)DataEncap.out(responseData));
                }
            }
        };
    }

    private IpcData build(Envelop community, Envelop envelop) {
        community.setHeaders(envelop.headers());
        community.setUser(envelop.user());
        IpcData responseData = new IpcData();
        responseData.setType(IpcType.UNITY);
        DataEncap.in(responseData, community);
        return responseData;
    }

    private Transit getTransit(Method method) {
        Transit transit;
        Ipc annotation = method.getAnnotation(Ipc.class);
        String to = (String)Instance.invoke((Object)annotation, (String)"to", (Object[])new Object[0]);
        if (StringUtil.isNil((String)to)) {
            transit = (Transit)Instance.singleton(FinalTransit.class, (Object[])new Object[0]);
            LOGGER.info("[ ZERO ] --> final node found, will provide response. method {0} of {1}", new Object[]{method, method.getDeclaringClass()});
        } else {
            transit = (Transit)Instance.singleton(NodeTransit.class, (Object[])new Object[0]);
            LOGGER.info("[ ZERO ] --> middle node found, will transfer -->. method {0} of {1}", new Object[]{method, method.getDeclaringClass()});
        }
        transit.connect(method);
        return transit;
    }
}

