/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro.ipc.client;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.tp.ipc.eon.IpcRequest;
import io.vertx.tp.ipc.eon.IpcResponse;
import io.vertx.tp.ipc.service.UnityServiceGrpc;
import io.vertx.up.atom.Envelop;
import io.vertx.up.atom.flux.IpcData;
import io.vertx.up.exception._500UnexpectedRpcException;
import io.vertx.up.micro.ipc.DataEncap;
import io.vertx.up.micro.ipc.client.RpcStub;
import io.vertx.up.micro.ipc.client.SslTool;

public class UnityStub
implements RpcStub {
    @Override
    public Future<Envelop> send(Vertx vertx, IpcData data) {
        ManagedChannel channel = SslTool.getChannel(vertx, data);
        UnityServiceGrpc.UnityServiceVertxStub stub = UnityServiceGrpc.newVertxStub((Channel)channel);
        IpcRequest request = DataEncap.in(data);
        Future handler = Future.future();
        stub.unityCall(request, response -> {
            if (response.succeeded()) {
                handler.complete((Object)DataEncap.out((IpcResponse)response.result()));
            } else {
                Throwable ex = response.cause();
                if (null != ex) {
                    Envelop envelop = Envelop.failure(new _500UnexpectedRpcException(this.getClass(), ex));
                    handler.complete((Object)envelop);
                }
            }
        });
        return handler;
    }
}

