/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro.ipc.client;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.servicediscovery.Record;
import io.vertx.up.annotations.Ipc;
import io.vertx.up.atom.Envelop;
import io.vertx.up.atom.agent.Event;
import io.vertx.up.atom.flux.IpcData;
import io.vertx.up.eon.em.IpcType;
import io.vertx.up.exception._501RpcAddressWrongException;
import io.vertx.up.exception._501RpcImplementException;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.discovery.IpcOrigin;
import io.vertx.up.micro.discovery.Origin;
import io.vertx.up.micro.ipc.DataEncap;
import io.vertx.up.micro.ipc.client.RpcStub;
import io.vertx.up.micro.ipc.client.UnityStub;
import io.vertx.up.tool.mirror.Instance;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TunnelClient {
    private transient Vertx vertx;
    private transient Event event;
    private final transient Annal logger;
    private static final Origin ORIGIN = (Origin)Instance.singleton(IpcOrigin.class, (Object[])new Object[0]);
    private static final ConcurrentMap<IpcType, RpcStub> STUBS = new ConcurrentHashMap<IpcType, RpcStub>(){
        {
            this.put(IpcType.UNITY, Instance.singleton(UnityStub.class, (Object[])new Object[0]));
        }
    };

    public static TunnelClient create(Class<?> clazz) {
        return new TunnelClient(clazz);
    }

    private TunnelClient(Class<?> clazz) {
        this.logger = Annal.get(clazz);
    }

    public TunnelClient connect(Vertx vertx) {
        this.vertx = vertx;
        return this;
    }

    public TunnelClient connect(Event event) {
        this.event = event;
        return this;
    }

    public Future<Envelop> send(Envelop envelop) {
        String address = (String)this.getValue("to");
        IpcType type = (IpcType)this.getValue("type");
        Record record = this.findTarget();
        IpcData data = new IpcData();
        data.setType(type);
        data.setAddress(address);
        DataEncap.in(data, record);
        DataEncap.in(data, envelop);
        RpcStub stub = STUBS.getOrDefault(type, (RpcStub)Instance.singleton(UnityStub.class, (Object[])new Object[0]));
        return stub.send(this.vertx, data);
    }

    private <T> T getValue(String attr) {
        Method method = this.event.getAction();
        Ipc annotation = method.getAnnotation(Ipc.class);
        return (T)Instance.invoke((Object)annotation, (String)attr, (Object[])new Object[0]);
    }

    private Record findTarget() {
        ConcurrentMap<String, Record> address = ORIGIN.getRegistryData();
        String target = (String)this.getValue("to");
        String name = (String)this.getValue("name");
        Record record = address.values().stream().filter(item -> name.equals(item.getName())).findFirst().orElse(null);
        Fn.flingWeb((null == record ? 1 : 0) != 0, (Annal)this.logger, _501RpcImplementException.class, (Object[])new Object[]{this.getClass(), name, target, this.event.getAction()});
        Fn.flingWeb((null == record.getMetadata() || !target.equals(record.getMetadata().getString("path")) ? 1 : 0) != 0, (Annal)this.logger, _501RpcAddressWrongException.class, (Object[])new Object[]{this.getClass(), target, name});
        this.logger.info("[ ZERO ] Find matched record {0}", new Object[]{record.toJson()});
        return record;
    }
}

