/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro.ipc.client;

import io.grpc.ManagedChannel;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.grpc.VertxChannelBuilder;
import io.vertx.up.atom.flux.IpcData;
import io.vertx.up.eon.em.CertType;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.ssl.TrustPipe;
import io.vertx.up.tool.Jackson;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.up.tool.mirror.Types;
import io.vertx.zero.marshal.node.Node;
import io.vertx.zero.marshal.node.ZeroUniform;

public class SslTool {
    private static final Annal LOGGER = Annal.get(SslTool.class);
    private static final Node<JsonObject> node = (Node)Instance.singleton(ZeroUniform.class, (Object[])new Object[0]);
    private static final String SSL = "ssl";

    public static ManagedChannel getChannel(Vertx vertx, IpcData data) {
        String grpcHost = data.getHost();
        Integer grpcPort = data.getPort();
        LOGGER.info("[ ZERO ] Build channel for host = {0}, port = {1}", new Object[]{grpcHost, String.valueOf(grpcPort)});
        VertxChannelBuilder builder = VertxChannelBuilder.forAddress((Vertx)vertx, (String)grpcHost, (int)grpcPort);
        JsonObject config = (JsonObject)node.read();
        Fn.safeSemi((null != config && null != config.getValue("rpc") ? 1 : 0) != 0, (Annal)LOGGER, () -> {
            JsonObject rpcConfig = config.getJsonObject("rpc");
            if (rpcConfig.containsKey(SSL) && Boolean.valueOf(rpcConfig.getValue(SSL).toString()).booleanValue()) {
                Object type;
                String name;
                JsonObject visited;
                JsonObject sslConfig = new JsonObject();
                if (rpcConfig.containsKey("extension") && null != (visited = Jackson.visitJObject((JsonObject)rpcConfig, (String[])new String[]{"extension", name = data.getName()}))) {
                    sslConfig.mergeIn(visited);
                }
                if (sslConfig.isEmpty()) {
                    sslConfig.mergeIn(Jackson.visitJObject((JsonObject)rpcConfig, (String[])new String[]{"uniform"}));
                }
                CertType certType = null == (type = sslConfig.getValue("type")) ? CertType.PEM : (CertType)Types.fromStr(CertType.class, (String)type.toString());
                TrustPipe<JsonObject> pipe = TrustPipe.get(certType);
                builder.useSsl(pipe.parse(sslConfig));
            } else {
                builder.usePlaintext(true);
            }
        });
        return builder.build();
    }
}

