/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.tp.etcd.center.EtcdData;
import io.vertx.up.annotations.Agent;
import io.vertx.up.eon.em.Etat;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.Pool;
import io.vertx.up.micro.ZeroAtomic;
import io.vertx.up.micro.center.ZeroRegistry;
import io.vertx.up.rs.Axis;
import io.vertx.up.rs.router.EventAxis;
import io.vertx.up.rs.router.RouterAxis;
import io.vertx.up.rs.router.WallAxis;
import io.vertx.up.tool.Net;
import io.vertx.up.tool.StringUtil;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.up.web.ZeroGrid;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

@Agent
public class ZeroHttpAgent
extends AbstractVerticle {
    private static final Annal LOGGER = Annal.get(ZeroHttpAgent.class);
    private static final ConcurrentMap<Integer, String> SERVICES = ZeroGrid.getServerNames();

    public void start() {
        Axis routerAxiser = (Axis)Fn.poolThread(Pool.ROUTERS, () -> (Axis)Instance.instance(RouterAxis.class, (Object[])new Object[0]));
        Axis axiser = (Axis)Fn.poolThread(Pool.EVENTS, () -> (Axis)Instance.instance(EventAxis.class, (Object[])new Object[0]));
        Axis wallAxiser = (Axis)Fn.poolThread(Pool.WALLS, () -> (Axis)Instance.instance(WallAxis.class, (Object[])new Object[]{this.vertx}));
        ZeroAtomic.HTTP_OPTS.forEach((port, option) -> {
            HttpServer server = this.vertx.createHttpServer(option);
            Router router = Router.router((Vertx)this.vertx);
            routerAxiser.mount(router);
            wallAxiser.mount(router);
            axiser.mount(router);
            server.requestHandler(arg_0 -> ((Router)router).accept(arg_0)).listen();
            this.registryServer((HttpServerOptions)option, router);
        });
    }

    public void stop() {
        Fn.itMap(ZeroAtomic.HTTP_OPTS, (port, config) -> {
            if (EtcdData.enabled()) {
                ZeroRegistry registry = ZeroRegistry.create(((Object)((Object)this)).getClass());
                registry.registryHttp((String)SERVICES.get(port), (HttpServerOptions)config, Etat.STOPPED);
            }
        });
    }

    private void registryServer(HttpServerOptions options, Router router) {
        Integer port = options.getPort();
        AtomicInteger out = (AtomicInteger)ZeroAtomic.HTTP_START_LOGS.get(port);
        if (0 == out.getAndIncrement()) {
            String portLiteral = String.valueOf(port);
            LOGGER.info("[ ZERO ] ( Http Server ) {0} (id = {1}) Agent has deployed HTTP Server on {2}.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.deploymentID(), portLiteral});
            List routes = router.getRoutes();
            TreeMap<String, Route> routeMap = new TreeMap<String, Route>();
            TreeSet<String> tree = new TreeSet<String>();
            for (Route route2 : routes) {
                String path2 = null == route2.getPath() ? "/*" : route2.getPath();
                routeMap.put(path2, route2);
                if ("/*".equals(path2)) continue;
                tree.add(path2);
            }
            routeMap.forEach((path, route) -> LOGGER.info("[ ZERO ] ( Uri Register ) \"{1}\" has been deployed by {0}, Options = {2}.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), path, route.toString()}));
            String address = MessageFormat.format("http://{0}:{1}/", Net.getIPv4(), portLiteral);
            LOGGER.info("[ ZERO ] ( Http Server ) {0} Http Server has been started successfully. Endpoint: {1}.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), address});
            String name = (String)SERVICES.get(port);
            this.startRegistry(name, options, tree);
        }
    }

    private void startRegistry(String name, HttpServerOptions options, Set<String> tree) {
        if (EtcdData.enabled()) {
            JsonObject data = this.getMessage(name, options, tree);
            EventBus bus = this.vertx.eventBus();
            String address = "ZERO://MICRO/REGISTRY/START";
            LOGGER.info("[ ZERO ] ---> {2} ( Http Server ) {0} ( name = {1} ) is sending data to internal address.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), name, "ZERO://MICRO/REGISTRY/START"});
            bus.publish("ZERO://MICRO/REGISTRY/START", (Object)data);
        }
    }

    private JsonObject getMessage(String name, HttpServerOptions options, Set<String> tree) {
        JsonObject data = new JsonObject();
        data.put("name", name);
        data.put("options", options.toJson());
        if (null != tree) {
            data.put("uris", StringUtil.join(tree));
        }
        return data;
    }
}

