/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.kidd.unseen;

import io.vertx.up.log.Annal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;

public class Apeak
implements Iterable<Map.Entry<String, String>> {
    private static final Annal LOGGER = Annal.get(Apeak.class);
    private final transient List<String> from = new ArrayList<String>();
    private final transient List<String> to = new ArrayList<String>();
    private final transient ConcurrentMap<String, String> vector = new ConcurrentHashMap<String, String>();

    public static Apeak create(String from, String to) {
        return new Apeak(from, to);
    }

    private Apeak(String from, String to) {
        this.add(from, to);
    }

    public Apeak add(String from, String to) {
        if (this.from.contains(from) || this.to.contains(to)) {
            if (this.from.contains(from)) {
                LOGGER.warn("[ ZERO ] Zero system detected duplicated from/to {0}. Type = {1}.", new Object[]{from, "From"});
            }
            if (this.to.contains(to)) {
                LOGGER.warn("[ ZERO ] Zero system detected duplicated from/to {0}. Type = {1}.", new Object[]{to, "To"});
            }
        } else {
            this.from.add(from);
            this.to.add(to);
            this.vector.put(from, to);
        }
        return this;
    }

    public Apeak remove(String from) {
        int index = from.indexOf(from);
        if (0 <= index) {
            this.remove(from);
            this.to.remove(this.to.get(index));
            this.vector.remove(from);
        }
        return this;
    }

    public Apeak clear() {
        this.from.clear();
        this.to.clear();
        this.vector.clear();
        return this;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.vector.entrySet().iterator();
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<String, String>> action) {
        this.vector.entrySet().forEach(action);
    }

    @Override
    public Spliterator<Map.Entry<String, String>> spliterator() {
        return this.vector.entrySet().spliterator();
    }
}

