/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.kidd;

import io.reactivex.Observable;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.func.Fn;
import io.vertx.up.kidd.unseen.Apeak;
import io.vertx.up.tool.mirror.Types;
import java.util.Map;
import java.util.Objects;

public class Vertical {
    public static JsonObject to(JsonObject data, Apeak apeak) {
        return Vertical.to(data, apeak, true);
    }

    public static JsonObject to(JsonObject data, Apeak apeak, boolean recursion) {
        Observable.fromIterable((Iterable)apeak).filter(Objects::nonNull).filter(item -> Objects.nonNull(item.getKey()) && Objects.nonNull(item.getValue())).subscribe(item -> Vertical.execute(data, apeak, item, recursion));
        return data;
    }

    private static void execute(JsonObject data, Apeak apeak, Map.Entry<String, String> item, boolean recursion) {
        Fn.safeNull(() -> {
            Object value = data.getValue((String)item.getKey());
            data.put((String)item.getValue(), value);
            data.remove((String)item.getKey());
            if (recursion) {
                Observable.fromIterable((Iterable)data.fieldNames()).filter(Objects::nonNull).map(field -> {
                    Object reference = data.getValue(field);
                    if (null == reference) {
                        reference = "";
                    } else if (Types.isJObject((Object)reference)) {
                        reference = Vertical.to((JsonObject)reference, apeak);
                    } else if (Types.isJArray((Object)reference)) {
                        reference = Vertical.to((JsonArray)reference, apeak);
                    }
                    return reference;
                }).subscribe();
            }
        }, (Object[])new Object[]{data, item, item.getKey(), item.getValue()});
    }

    public static JsonArray to(JsonArray array, Apeak apeak) {
        return Vertical.to(array, apeak, true);
    }

    public static JsonArray to(JsonArray array, Apeak apeak, boolean recursion) {
        Observable.fromIterable((Iterable)array).filter(Objects::nonNull).filter(Types::isJObject).map(item -> (JsonObject)item).subscribe(item -> Vertical.to(item, apeak, recursion));
        return array;
    }
}

