/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.atom.query;

import io.vertx.core.json.JsonObject;
import io.vertx.up.func.Fn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class Sorter
implements Serializable {
    private final transient List<String> field = new ArrayList<String>();
    private final transient List<Boolean> asc = new ArrayList<Boolean>();

    public static Sorter create(String field, Boolean asc) {
        return new Sorter(field, asc);
    }

    private Sorter(String field, Boolean asc) {
        this.field.add(field);
        this.asc.add(asc);
    }

    public <T> JsonObject toJson(Function<Boolean, T> function) {
        JsonObject sort = new JsonObject();
        Fn.itList(this.field, (item, index) -> {
            boolean mode = this.asc.get((int)index);
            Object result = function.apply(mode);
            sort.put(item, result);
        });
        return sort;
    }

    public Sorter add(String field, Boolean asc) {
        this.field.add(field);
        this.asc.add(asc);
        return this;
    }

    public Sorter clear() {
        this.field.clear();
        this.asc.clear();
        return this;
    }
}

