/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.atom.query;

import io.vertx.core.json.JsonObject;
import io.vertx.up.func.Fn;
import java.io.Serializable;

public class Pager
implements Serializable {
    private final transient int page;
    private final transient int size;
    private transient int start;
    private transient int end;

    public static Pager create(Integer page, Integer size) {
        return new Pager(page, size);
    }

    public static Pager create(JsonObject pageJson) {
        int page = pageJson.getInteger("page");
        int size = pageJson.getInteger("size");
        return new Pager(page, size);
    }

    private Pager(Integer page, Integer size) {
        this.page = page;
        this.size = size;
        Fn.safeNull(() -> {
            this.start = (page - 1) * size;
            this.end = page * size;
        }, (Object[])new Object[]{page, size});
    }

    public JsonObject toJson() {
        JsonObject data = new JsonObject();
        data.put("page", Integer.valueOf(this.page));
        data.put("size", Integer.valueOf(this.size));
        return data;
    }

    public int getPage() {
        return this.page;
    }

    public int getSize() {
        return this.size;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getTop() {
        return this.size;
    }
}

