/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.atom;

import feign.Feign;
import feign.Request;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.codec.JsonObjectDecoder;
import feign.codec.JsonObjectEncoder;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.exception.TpKeyMissingException;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.zero.atom.Ruler;
import io.vertx.zero.exception.ZeroException;
import io.vertx.zero.marshal.node.Node;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class FeignDepot
implements Serializable {
    private static final Annal LOGGER = Annal.get(FeignDepot.class);
    private static final ConcurrentMap<String, FeignDepot> CACHE = new ConcurrentHashMap<String, FeignDepot>();
    private static final Node<JsonObject> TP = Node.infix((String)"tp");
    private static final String KEY = "feign";
    private transient String endpoint;
    private transient JsonObject config;
    private transient Request.Options options;
    private transient Retryer.Default defaults;

    public static FeignDepot create(String key) {
        return (FeignDepot)Fn.pool(CACHE, (Object)key, () -> new FeignDepot(key));
    }

    public <T> T build(Class<T> clazz) {
        return this.build(clazz, null);
    }

    public <T> T build(Class<T> clazz, ErrorDecoder decoder) {
        Feign.Builder builder = Feign.builder();
        if (null != this.options) {
            builder.options(this.options);
        }
        if (null != this.defaults) {
            builder.retryer((Retryer)this.defaults);
        }
        builder.encoder((Encoder)new JsonObjectEncoder());
        builder.decoder((Decoder)new JsonObjectDecoder());
        if (null != decoder) {
            builder.errorDecoder(decoder);
        }
        return (T)builder.target(clazz, this.endpoint);
    }

    private FeignDepot(String key) {
        JsonObject config = (JsonObject)TP.read();
        Fn.flingUp((null == config || !config.containsKey(key) ? 1 : 0) != 0, (Annal)LOGGER, TpKeyMissingException.class, (Object[])new Object[]{this.getClass(), key, config});
        if (this.verify(config, key)) {
            this.init(config.getJsonObject(key));
        }
    }

    private void init(JsonObject raw) {
        this.initOpts(raw);
        this.endpoint = raw.getString("endpoint");
        this.config = raw.containsKey("config") ? raw.getJsonObject("config") : new JsonObject();
    }

    private void initOpts(JsonObject raw) {
        JsonObject normalized = this.getOptions();
        if (raw.containsKey("timeout")) {
            JsonObject options = raw.getJsonObject("timeout");
            normalized = normalized.mergeIn(options);
        }
        this.options = new Request.Options(normalized.getInteger("connect").intValue(), normalized.getInteger("read").intValue());
        normalized = this.getDefaults();
        if (raw.containsKey("retry")) {
            JsonObject defaults = raw.getJsonObject("retry");
            normalized = normalized.mergeIn(defaults);
        }
        this.defaults = new Retryer.Default((long)normalized.getInteger("period").intValue(), (long)normalized.getInteger("maxPeriod").intValue(), normalized.getInteger("attempts").intValue());
    }

    private JsonObject getDefaults() {
        JsonObject defaults = new JsonObject();
        defaults.put("period", Integer.valueOf(5000));
        defaults.put("maxPeriod", Integer.valueOf(5000));
        defaults.put("attempts", Integer.valueOf(3));
        return defaults;
    }

    private JsonObject getOptions() {
        JsonObject defaults = new JsonObject();
        defaults.put("connect", Integer.valueOf(1000));
        defaults.put("read", Integer.valueOf(3500));
        return defaults;
    }

    private boolean verify(JsonObject config, String key) {
        Object value = config.getValue(key);
        boolean verified = true;
        if (JsonObject.class == value.getClass()) {
            try {
                Ruler.verify((String)KEY, (JsonObject)((JsonObject)value));
            }
            catch (ZeroException ex) {
                LOGGER.zero(ex);
                verified = false;
            }
        } else {
            LOGGER.warn("[ ZERO ] ( Tp ) The key = {0} in config {1} type is wrong.", new Object[]{key, config.encode()});
            verified = false;
        }
        return verified;
    }
}

