/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.web;

import io.reactivex.Single;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.reactivex.core.Vertx;
import io.vertx.up.Launcher;
import io.vertx.up.boot.Motor;
import io.vertx.up.log.Annal;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;

public class ZeroLauncher
implements Launcher<Vertx> {
    private static final Annal LOGGER = Annal.get(ZeroLauncher.class);
    private static final ConcurrentMap<String, Vertx> VERTX = new ConcurrentHashMap<String, Vertx>();

    public void start(Consumer<Vertx> callback) {
        Motor.start(this.getClass(), callback, this::startStandalone, this::startCluster, (Annal)LOGGER);
    }

    public void stop(Consumer<Vertx> callback) {
    }

    private void startStandalone(Consumer<Vertx> consumer) {
        Motor.each((name, option) -> {
            Vertx vertx = Vertx.vertx((VertxOptions)option);
            Motor.codec((EventBus)vertx.eventBus().getDelegate());
            VERTX.putIfAbsent((String)name, vertx);
            consumer.accept(vertx);
        });
    }

    private void startCluster(ClusterManager manager, Consumer<Vertx> consumer) {
        Motor.each((name, option) -> {
            option.setClusterManager(manager);
            Single observable = Vertx.rxClusteredVertx((VertxOptions)option);
            observable.subscribe(vertx -> {
                Motor.codec((EventBus)vertx.eventBus().getDelegate());
                VERTX.putIfAbsent((String)name, (Vertx)vertx);
                consumer.accept((Vertx)vertx);
            });
        });
    }
}

