/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.micro;

import io.reactivex.Single;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.reactivex.core.AbstractVerticle;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.http.HttpServer;
import io.vertx.reactivex.ext.web.Route;
import io.vertx.reactivex.ext.web.Router;
import io.vertx.rx.micro.Pool;
import io.vertx.rx.rs.router.EventAxis;
import io.vertx.rx.rs.router.RouterAxis;
import io.vertx.up.annotations.Agent;
import io.vertx.up.eon.em.ServerType;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.ZeroAtomic;
import io.vertx.up.rs.Axis;
import io.vertx.up.tool.mirror.Instance;
import java.text.MessageFormat;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

@Agent(type=ServerType.RX)
public class ZeroRxAgent
extends AbstractVerticle {
    private static final Annal LOGGER = Annal.get(ZeroRxAgent.class);
    private final transient String NAME = ((Object)((Object)this)).getClass().getSimpleName();

    public void start() {
        Axis routerAxiser = (Axis)Fn.poolThread(Pool.ROUTERS, () -> (Axis)Instance.instance(RouterAxis.class, (Object[])new Object[0]));
        Axis axiser = (Axis)Fn.poolThread(Pool.EVENTS, () -> (Axis)Instance.instance(EventAxis.class, (Object[])new Object[0]));
        ZeroAtomic.RX_OPTS.forEach((port, option) -> {
            HttpServer server = this.vertx.createHttpServer(option);
            Router router = Router.router((Vertx)this.vertx);
            routerAxiser.mount((Object)router);
            axiser.mount((Object)router);
            Single result = server.requestHandler(arg_0 -> ((Router)router).accept(arg_0)).rxListen();
            result.subscribe(rxServer -> this.recordServer((HttpServerOptions)option, router));
        });
    }

    private void recordServer(HttpServerOptions options, Router router) {
        Integer port = options.getPort();
        AtomicInteger out = (AtomicInteger)ZeroAtomic.RX_START_LOGS.get(port);
        if (0 == out.getAndIncrement()) {
            String portLiteral = String.valueOf(port);
            LOGGER.info("[ ZERO ] ( Rx Server ) {0} (id = {1}) Agent has deployed Rx Server on {2}.", new Object[]{this.NAME, this.deploymentID(), portLiteral});
            List routes = router.getRoutes();
            TreeMap<String, Route> routeMap = new TreeMap<String, Route>();
            for (Route route2 : routes) {
                String path2 = null == route2.getPath() ? "/*" : route2.getPath();
                routeMap.put(path2, route2);
            }
            routeMap.forEach((path, route) -> LOGGER.info("[ ZERO ] ( Uri Register ) \"{1}\" has been deployed by {0}, Options = {2}.", new Object[]{this.NAME, path, route.toString()}));
            String address = MessageFormat.format("http://{0}:{1}/", options.getHost(), portLiteral);
            LOGGER.info("[ ZERO ] ( Rx Server ) {0} Rx Server has been started successfully. Endpoint: {1}.", new Object[]{this.NAME, address});
        }
    }
}

