/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.zero.marshal.reliable;

import io.vertx.core.json.JsonObject;
import io.vertx.up.func.Fn;
import io.vertx.up.tool.mirror.Types;
import io.vertx.zero.eon.em.DataType;
import io.vertx.zero.exception.ZeroException;
import io.vertx.zero.exception.demon.DataTypeWrongException;
import io.vertx.zero.marshal.reliable.AbstractInsurer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class TypedInsurer
extends AbstractInsurer {
    private static final ConcurrentMap<DataType, Function<Object, Boolean>> FUNS = new ConcurrentHashMap<DataType, Function<Object, Boolean>>(){
        {
            this.put(DataType.BOOLEAN, Types::isBoolean);
            this.put(DataType.STRING, input -> Boolean.TRUE);
            this.put(DataType.INTEGER, Types::isInteger);
            this.put(DataType.DECIMAL, Types::isDecimal);
            this.put(DataType.DATE, Types::isDate);
            this.put(DataType.JOBJECT, Types::isJObject);
            this.put(DataType.JARRAY, Types::isJArray);
            this.put(DataType.CLASS, Types::isClass);
        }
    };

    @Override
    public void flumen(JsonObject data, JsonObject rule) throws ZeroException {
        Fn.shuntZero(() -> {
            if (rule.containsKey("typed")) {
                JsonObject fields = rule.getJsonObject("typed");
                Fn.etJObject(fields, (item, name) -> {
                    DataType key = Types.fromStr(DataType.class, item.toString());
                    Function<Object, Boolean> fnTest = FUNS.getOrDefault((Object)key, input -> Boolean.TRUE);
                    if (data.containsKey(name)) {
                        Object value = data.getValue(name);
                        Fn.flingZero(fnTest.apply(data.getValue(name)) == false, this.getLogger(), DataTypeWrongException.class, new Object[]{this.getClass(), name, value, key});
                    }
                });
            }
        }, rule, data);
    }
}

