/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.zero.marshal.node;

import io.vertx.core.json.JsonObject;
import io.vertx.up.func.Fn;
import io.vertx.up.tool.io.IO;
import io.vertx.zero.marshal.node.Storage;

public class ZeroTool {
    public static String produce(String key) {
        if (null == key) {
            return "vertx.yml";
        }
        return "vertx-" + key + "." + "yml";
    }

    static JsonObject read(String key, boolean extension) {
        JsonObject internal;
        JsonObject original = ZeroTool.readDirect(ZeroTool.produce(key));
        JsonObject merged = new JsonObject();
        if (extension && null != (internal = ZeroTool.readDirect("ke/config/" + ZeroTool.produce(key)))) {
            merged.mergeIn(internal, true);
        }
        if (null != original) {
            merged.mergeIn(original, true);
        }
        return merged;
    }

    private static JsonObject readDirect(String filename) {
        if (Storage.CONFIG.containsKey(filename)) {
            return (JsonObject)Storage.CONFIG.get(filename);
        }
        JsonObject data = Fn.getJvm(null, () -> (JsonObject)IO.getYaml(filename), new Object[]{filename});
        if (null != data && !data.isEmpty()) {
            Storage.CONFIG.put(filename, data);
        }
        return data;
    }
}

