/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.zero.log;

import io.vertx.core.VertxException;
import io.vertx.core.logging.Logger;
import io.vertx.up.func.Fn;
import io.vertx.zero.exception.ZeroException;
import java.text.MessageFormat;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class Log {
    public static void jvm(Logger logger, Throwable ex) {
        Fn.safeNull(arg_0 -> ((Logger)logger).warn(arg_0), ex);
        ex.printStackTrace();
    }

    public static void zero(Logger logger, ZeroException ex) {
        Fn.safeNull(arg_0 -> ((Logger)logger).warn(arg_0), ex);
    }

    public static void vertx(Logger logger, VertxException ex) {
        Fn.safeNull(arg_0 -> ((Logger)logger).warn(arg_0), ex);
    }

    public static void info(Logger logger, String pattern, Object ... rest) {
        Log.log(() -> ((Logger)logger).isInfoEnabled(), arg_0 -> ((Logger)logger).info(arg_0), pattern, rest);
    }

    public static void debug(Logger logger, String pattern, Object ... rest) {
        Log.log(() -> true, arg_0 -> ((Logger)logger).debug(arg_0), pattern, rest);
    }

    public static void warn(Logger logger, String pattern, Object ... rest) {
        Log.log(() -> true, arg_0 -> ((Logger)logger).warn(arg_0), pattern, rest);
    }

    public static void error(Logger logger, String pattern, Object ... rest) {
        Log.log(() -> true, arg_0 -> ((Logger)logger).error(arg_0), pattern, rest);
    }

    private static void log(Supplier<Boolean> fnPre, Consumer<Object> fnLog, String message, Object ... rest) {
        if (fnPre.get().booleanValue()) {
            if (0 < rest.length) {
                fnLog.accept(MessageFormat.format(message, rest));
            } else {
                fnLog.accept(message);
            }
        }
    }
}

