/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.tool.mirror;

import io.reactivex.Observable;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.mirror.PackScanner;
import io.vertx.up.tool.mirror.PackThread;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public final class Pack {
    private static final Annal LOGGER = Annal.get(Pack.class);
    private static final Set<Class<?>> CLASSES = new HashSet();
    private static final Set<String> FORBIDDEN = new HashSet<String>(){
        {
            this.add("java");
            this.add("javax");
            this.add("jdk");
            this.add("org.xml");
            this.add("org.yaml");
            this.add("com.intellij");
            this.add("sun");
            this.add("com.sun");
            this.add("io.netty");
            this.add("com.fasterxml");
            this.add("ch.qos");
            this.add("org.slf4j");
            this.add("io.vertx.core");
            this.add("io.vertx.spi");
            this.add("org.ow2");
            this.add("org.objectweb");
            this.add("com.esotericsoftware");
            this.add("com.hazelcast");
            this.add("org.glassfish");
            this.add("org.junit");
            this.add("junit");
            this.add("org.hamcrest");
        }
    };

    public static Set<Class<?>> getClasses(Predicate<Class<?>> filter, String ... zeroScans) {
        if (CLASSES.isEmpty()) {
            if (0 < zeroScans.length) {
                CLASSES.addAll(Pack.multiClasses(zeroScans, filter));
            } else {
                Package[] packages = Package.getPackages();
                HashSet<String> packageDirs = new HashSet<String>();
                for (Package pkg : packages) {
                    String pending = pkg.getName();
                    boolean skip = FORBIDDEN.stream().anyMatch(pending::startsWith);
                    if (skip) continue;
                    packageDirs.add(pending);
                }
                LOGGER.info("[ ZERO ] Zero system scanned {0}/{1} packages.", String.valueOf(packageDirs.size()), String.valueOf(packages.length));
                CLASSES.addAll(Pack.multiClasses(packageDirs.toArray(new String[0]), filter));
            }
        }
        return CLASSES;
    }

    private static Set<Class<?>> singleClasses(String[] packageDir, Predicate<Class<?>> filter) {
        HashSet result = new HashSet();
        Observable.fromArray((Object[])packageDir).map(pkgName -> PackScanner.getClasses(filter, pkgName)).subscribe(result::addAll);
        return result;
    }

    private static Set<Class<?>> multiClasses(String[] packageDir, Predicate<Class<?>> filter) {
        HashSet<PackThread> references = new HashSet<PackThread>();
        for (String pkgName : packageDir) {
            PackThread thread = new PackThread(pkgName, filter);
            references.add(thread);
            thread.start();
        }
        HashSet result = new HashSet();
        try {
            for (PackThread item : references) {
                item.join();
            }
            for (PackThread thread : references) {
                result.addAll(thread.getClasses());
            }
        }
        catch (InterruptedException ex) {
            LOGGER.jvm(ex);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private Pack() {
    }
}

