/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.tool.mirror;

import io.vertx.up.func.Fn;
import io.vertx.up.tool.container.KeyPair;
import io.vertx.up.tool.mirror.Instance;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public final class Anno {
    public static ConcurrentMap<String, Annotation> get(Class<?> clazz) {
        return Fn.get(() -> {
            Annotation[] annotationes = clazz.getDeclaredAnnotations();
            return Fn.zipper(annotationes, item -> item.annotationType().getName(), item -> item);
        }, clazz);
    }

    public static Annotation[] query(Class<?> clazz, Class<? extends Annotation> methodCls) {
        return Fn.get(() -> {
            Method[] methods = clazz.getDeclaredMethods();
            List<Method> methodSet = Arrays.asList(methods);
            List result = methodSet.stream().filter(item -> item.isAnnotationPresent(methodCls)).collect(Collectors.toList());
            ArrayList resultAnnos = new ArrayList();
            for (Method method : result) {
                Object anno = method.getAnnotation(methodCls);
                if (null == anno) continue;
                resultAnnos.add(anno);
            }
            return resultAnnos.toArray(new Annotation[0]);
        }, clazz, methodCls);
    }

    public static boolean isMark(Field field, Set<Class<? extends Annotation>> annoCls) {
        return annoCls.stream().anyMatch(field::isAnnotationPresent);
    }

    public static int occurs(Annotation[][] annotations, Class<? extends Annotation> annoCls) {
        AtomicInteger integer = new AtomicInteger(0);
        Fn.itMatrix(annotations, annotation -> {
            if (annotation.annotationType() == annoCls) {
                integer.incrementAndGet();
            }
        });
        return integer.get();
    }

    public static KeyPair<Integer, Class<?>> findParameter(Method method, Class<? extends Annotation> annoCls) {
        int index = 0;
        KeyPair<Integer, Class<?>> result = KeyPair.create();
        for (Parameter parameter : method.getParameters()) {
            if (parameter.isAnnotationPresent(annoCls)) {
                result.set(index, parameter.getType());
                break;
            }
            ++index;
        }
        return result;
    }

    public static boolean isMark(Class<?> clazz, Set<Class<? extends Annotation>> annoCls) {
        List<Field> fields = Arrays.asList(clazz.getDeclaredFields());
        return fields.stream().anyMatch(field -> Anno.isMark(field, annoCls));
    }

    public static <T, E extends Annotation> T getAttribute(Class<?> clazz, Class<E> annoCls, String attr) {
        E annotation = clazz.getAnnotation(annoCls);
        return Instance.invoke(annotation, attr, new Object[0]);
    }

    private Anno() {
    }
}

