/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.tool;

import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class Statute {
    private static final Annal LOGGER = Annal.get(Statute.class);

    public static <T> T findUnique(List<T> list, Predicate<T> fnFilter) {
        return (T)Fn.get(() -> {
            List filtered = list.stream().filter(fnFilter).collect(Collectors.toList());
            return Fn.getSemi(filtered.isEmpty(), LOGGER, Fn::nil, () -> filtered.get(0));
        }, list, fnFilter);
    }

    public static <K, T, V> ConcurrentMap<K, V> reduce(ConcurrentMap<K, T> from, ConcurrentMap<T, V> to) {
        ConcurrentHashMap result = new ConcurrentHashMap();
        from.forEach((key, middle) -> {
            Object value = to.get(middle);
            if (null != value) {
                result.put(key, value);
            }
        });
        return result;
    }

    public static <K, V> ConcurrentMap<K, V> reduce(Set<K> from, ConcurrentMap<K, V> to) {
        ConcurrentHashMap result = new ConcurrentHashMap();
        from.forEach(key -> {
            Object value = to.get(key);
            if (null != value) {
                result.put(key, value);
            }
        });
        return result;
    }

    public static <F, T> ConcurrentMap<F, T> zipper(List<F> keys, List<T> values) {
        ConcurrentHashMap result = new ConcurrentHashMap();
        Fn.itList(keys, (key, index) -> {
            Object value = Statute.getEnsure(values, index);
            if (null != key && null != value) {
                result.put(key, value);
            }
        });
        return result;
    }

    public static <F, S, T> List<T> zipper(List<F> first, List<S> second, BiFunction<F, S, T> function) {
        ArrayList result = new ArrayList();
        Fn.itList(first, (key, index) -> {
            Object value = Statute.getEnsure(second, index);
            Object merged = function.apply(key, value);
            if (null != merged) {
                result.add(merged);
            }
        });
        return result;
    }

    private static <T> T getEnsure(List<T> list, int index) {
        return 0 <= index && index < list.size() ? (T)list.get(index) : null;
    }

    private Statute() {
    }
}

