/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.tool;

import io.vertx.up.func.Fn;
import io.vertx.zero.eon.Values;
import java.security.MessageDigest;

public class Codec {
    public static String md5(String input) {
        return Fn.getJvm(() -> {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] source = input.getBytes(Values.CHARSET);
            digest.update(source);
            byte[] middle = digest.digest();
            char[] middleStr = new char[32];
            int position = 0;
            for (int idx = 0; idx < 16; ++idx) {
                byte byte0 = middle[idx];
                middleStr[position++] = Values.HEX_ARR[byte0 >>> 4 & 0xF];
                middleStr[position++] = Values.HEX_ARR[byte0 & 0xF];
            }
            return new String(middleStr);
        }, input);
    }

    public static String sha256(String input) {
        return Codec.sha(input, "SHA-256");
    }

    public static String sha512(String input) {
        return Codec.sha(input, "SHA-512");
    }

    private static String sha(String strText, String strType) {
        return Fn.getJvm(() -> {
            MessageDigest messageDigest = MessageDigest.getInstance(strType);
            messageDigest.update(strText.getBytes());
            byte[] byteBuffer = messageDigest.digest();
            StringBuilder strHexString = new StringBuilder();
            for (int i = 0; i < byteBuffer.length; ++i) {
                String hex = Integer.toHexString(0xFF & byteBuffer[i]);
                if (hex.length() == 1) {
                    strHexString.append('0');
                }
                strHexString.append(hex);
            }
            return strHexString.toString();
        }, strText, strType);
    }
}

