/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.log;

import io.vertx.core.VertxException;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.up.web.ZeroAmbient;
import io.vertx.zero.exception.ZeroException;
import io.vertx.zero.log.Log;
import io.vertx.zero.log.internal.Log4JAnnal;

class CommonAnnal
implements Annal {
    private static final Logger RECORD = LoggerFactory.getLogger(CommonAnnal.class);
    private final transient Annal logger;

    public CommonAnnal(Class<?> clazz) {
        Class<Object> inject = ZeroAmbient.getPlugin("logger");
        if (null == inject) {
            Log.debug(RECORD, "[ZERO] The inject Annal has not been configured, will select internal for {0}.", clazz);
            inject = Log4JAnnal.class;
        }
        Log.debug(RECORD, "[ZERO] The logger ( Annal = {0} ) has been selected for {1} to record logs.", inject, clazz);
        this.logger = (Annal)Instance.instance(inject, clazz);
    }

    @Override
    public void warn(String key, Object ... args) {
        this.logger.warn(key, args);
    }

    @Override
    public void error(String key, Object ... args) {
        this.logger.error(key, args);
    }

    @Override
    public void vertx(VertxException ex) {
        this.logger.vertx(ex);
    }

    @Override
    public void zero(ZeroException ex) {
        this.logger.zero(ex);
    }

    @Override
    public void jvm(Throwable ex) {
        this.logger.jvm(ex);
    }

    @Override
    public void info(String key, Object ... args) {
        this.logger.info(key, args);
    }

    @Override
    public void debug(String key, Object ... args) {
        this.logger.debug(key, args);
    }
}

