/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.quiz.fakecluster;

import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.spi.cluster.ChoosableIterable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

class ChoosableSet<T>
implements ChoosableIterable<T> {
    private final Set<T> ids;
    private volatile Iterator<T> iter;

    public ChoosableSet(int initialSize) {
        this.ids = new ConcurrentHashSet(initialSize);
    }

    public int size() {
        return this.ids.size();
    }

    public void add(T elem) {
        this.ids.add(elem);
    }

    public boolean remove(T elem) {
        return this.ids.remove(elem);
    }

    public void merge(ChoosableSet<T> toMerge) {
        this.ids.addAll(toMerge.ids);
    }

    public boolean isEmpty() {
        return this.ids.isEmpty();
    }

    public Iterator<T> iterator() {
        return this.ids.iterator();
    }

    public synchronized T choose() {
        if (!this.ids.isEmpty()) {
            if (this.iter == null || !this.iter.hasNext()) {
                this.iter = this.ids.iterator();
            }
            try {
                return this.iter.next();
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
        return null;
    }
}

