/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.zero.atom;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.io.IO;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.up.tool.mirror.Types;
import io.vertx.zero.exception.ZeroException;
import io.vertx.zero.marshal.reliable.ForbiddenInsurer;
import io.vertx.zero.marshal.reliable.Insurer;
import io.vertx.zero.marshal.reliable.RequiredInsurer;
import io.vertx.zero.marshal.reliable.TypedInsurer;
import java.text.MessageFormat;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Ruler {
    private static final Annal LOGGER = Annal.get(Ruler.class);
    private static final String RULE_PATH = "ke/rules/{0}.yml";
    private static final ConcurrentMap<String, JsonObject> RULE_MAP = new ConcurrentHashMap<String, JsonObject>();

    public static void verify(String file, JsonObject data) throws ZeroException {
        Fn.shuntZero(() -> {
            JsonObject rule = Ruler.getRule(file);
            Ruler.verifyItem(data, rule);
            for (String field : data.fieldNames()) {
                Object value = data.getValue(field);
                Fn.shuntZero(() -> {
                    if (Types.isJObject(value) || Types.isJArray(value)) {
                        String filename = file + "." + field;
                        if (Types.isJObject(value)) {
                            Ruler.verify(filename, (JsonObject)value);
                        } else if (Types.isJArray(value)) {
                            Ruler.verify(filename, (JsonArray)value);
                        }
                    }
                }, value);
            }
        }, file, data);
    }

    public static void verify(String file, JsonArray data) throws ZeroException {
        Fn.shuntZero(() -> {
            JsonObject rule = Ruler.getRule(file);
            Ruler.verifyItem(data, rule);
            Fn.etJArray(data, (value, field) -> {
                String filename = file + "." + field;
                if (Types.isJObject(value)) {
                    Ruler.verify(filename, (JsonObject)value);
                } else if (Types.isJArray(value)) {
                    Ruler.verify(filename, (JsonArray)value);
                }
            });
        }, file, data);
    }

    private static <T> void verifyItem(T input, JsonObject rule) throws ZeroException {
        Fn.shuntZero(() -> {
            if (Types.isJArray(input)) {
                JsonArray data = (JsonArray)input;
                Insurer reference = (Insurer)Instance.singleton(RequiredInsurer.class, new Object[0]);
                reference.flumen(data, rule);
                reference = (Insurer)Instance.singleton(TypedInsurer.class, new Object[0]);
                reference.flumen(data, rule);
                reference = (Insurer)Instance.singleton(ForbiddenInsurer.class, new Object[0]);
                reference.flumen(data, rule);
            } else {
                JsonObject data = (JsonObject)input;
                Insurer reference = (Insurer)Instance.singleton(RequiredInsurer.class, new Object[0]);
                reference.flumen(data, rule);
                reference = (Insurer)Instance.singleton(TypedInsurer.class, new Object[0]);
                reference.flumen(data, rule);
                reference = (Insurer)Instance.singleton(ForbiddenInsurer.class, new Object[0]);
                reference.flumen(data, rule);
            }
        }, input, rule);
    }

    private static JsonObject getRule(String file) {
        String filename = MessageFormat.format(RULE_PATH, file);
        if (RULE_MAP.containsKey(filename)) {
            LOGGER.debug("[V] Rule file = {0}, read from memory directly.", filename);
        } else {
            LOGGER.debug("[V] Rule file = {0} has been hitted. ", filename);
        }
        return Fn.pool(RULE_MAP, filename, () -> (JsonObject)IO.getYaml(filename));
    }
}

