/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.tool.mirror;

import com.esotericsoftware.reflectasm.ConstructorAccess;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.mirror.Fantam;
import io.vertx.up.tool.mirror.Pack;
import io.vertx.up.tool.mirror.Storage;
import io.vertx.zero.exception.DuplicatedImplException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class Instance {
    private static final Annal LOGGER = Annal.get(Instance.class);

    public static <T> T instance(String name, Object ... params) {
        return Instance.instance(Instance.clazz(name), params);
    }

    public static <T> T instance(Class<?> clazz, Object ... params) {
        Object created = Fn.getJvm(() -> Instance.construct(clazz, params), clazz);
        return (T)Fn.getJvm(() -> created, created);
    }

    public static <T> Class<?> genericT(Class<?> target) {
        return Fn.getJvm(() -> {
            Type type = target.getGenericSuperclass();
            Class clazz = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
            return clazz;
        }, target);
    }

    public static <T> T singleton(String name, Object ... params) {
        return Instance.singleton(Instance.clazz(name), params);
    }

    public static <T> T singleton(Class<?> clazz, Object ... params) {
        Object created = Fn.pool(Storage.SINGLETON, clazz.getName(), () -> Instance.instance(clazz, params));
        return (T)Fn.getJvm(() -> created, created);
    }

    public static Class<?> clazz(String name) {
        return Fn.pool(Storage.CLASSES, name, () -> Fn.getJvm(() -> Thread.currentThread().getContextClassLoader().loadClass(name), name));
    }

    public static boolean isMatch(Class<?> clazz, Class<?> interfaceCls) {
        Class<?>[] interfaces = clazz.getInterfaces();
        return Arrays.stream(interfaces).anyMatch(item -> item.equals(interfaceCls));
    }

    public static <T> T invoke(Object instance, String name, Object ... args) {
        return Fantam.invokeObject(instance, name, args);
    }

    public static <T> T invoke(Class<?> interfaceCls, String name, Object ... args) {
        return Fantam.invokeInterface(interfaceCls, name, args);
    }

    public static <T> T getProxy(Method method) {
        Class<?> interfaceCls = method.getDeclaringClass();
        return Fantam.getProxy(interfaceCls);
    }

    public static <T> void set(Object instance, String name, T value) {
        Fn.safeNull(() -> Fn.safeJvm(() -> {
            Field field = instance.getClass().getDeclaredField(name);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(instance, value);
        }, LOGGER), instance, name, value);
    }

    public static <T> T get(Object instance, String name) {
        return (T)Fn.get(() -> Fn.safeJvm(() -> {
            Object result;
            Field field = instance.getClass().getDeclaredField(name);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (null != (result = field.get(instance))) {
                return result;
            }
            return null;
        }, LOGGER), instance, name);
    }

    public static boolean noarg(Class<?> clazz) {
        return Fn.get(Boolean.FALSE, () -> {
            Constructor<?>[] constructors = clazz.getDeclaredConstructors();
            boolean noarg = false;
            for (Constructor<?> constructor : constructors) {
                if (0 != constructor.getParameterTypes().length) continue;
                noarg = true;
            }
            return noarg;
        }, clazz);
    }

    public static Class<?> uniqueChild(Class<?> interfaceCls) {
        return Fn.get(null, () -> {
            Set<Class<?>> classes = Pack.getClasses(null, new String[0]);
            List filtered = classes.stream().filter(item -> interfaceCls.isAssignableFrom((Class<?>)item) && item != interfaceCls).collect(Collectors.toList());
            int size = filtered.size();
            Fn.flingUp(1 < size, LOGGER, DuplicatedImplException.class, Instance.class, interfaceCls);
            return 1 == size ? (Class)filtered.get(0) : null;
        }, new Object[]{interfaceCls});
    }

    private static <T> T construct(Class<?> clazz, Object ... params) {
        return (T)Fn.getJvm(() -> {
            Constructor<?>[] constructors;
            Object ret = null;
            for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
                if (0 == params.length) {
                    ret = Instance.construct(clazz);
                }
                if (params.length != constructor.getParameterTypes().length) continue;
                Object reference = constructor.newInstance(params);
                ret = Fn.getJvm(() -> reference, reference);
            }
            return ret;
        }, clazz, params);
    }

    private static <T> T construct(Class<T> clazz) {
        return (T)Fn.getJvm(() -> {
            ConstructorAccess access = ConstructorAccess.get((Class)clazz);
            return access.newInstance();
        }, clazz);
    }

    private Instance() {
    }
}

