/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.tool;

import io.vertx.up.func.Fn;
import io.vertx.up.tool.Iso;
import io.vertx.up.tool.Storage;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class Period {
    private static final List<DateTimeFormatter> DATETIMES = new ArrayList<DateTimeFormatter>(){
        {
            this.add(Iso.DATE_TIME);
            this.add(Iso.INSTANT);
            this.add(Iso.RFC1123_DATE_TIME);
            this.add(Iso.COMMON);
            this.add(Iso.READBALE);
        }
    };
    private static final List<DateTimeFormatter> DATES = new ArrayList<DateTimeFormatter>(){
        {
            this.add(Iso.DATE);
            this.add(Iso.BASIC_DATE);
            this.add(Iso.ORDINAL_DATE);
        }
    };
    private static final List<DateTimeFormatter> TIMES = new ArrayList<DateTimeFormatter>(){
        {
            this.add(Iso.TIME);
        }
    };

    public static LocalDateTime toFull(String literal) {
        Optional hit = Fn.get(Optional.empty(), () -> DATETIMES.stream().filter(formatter -> null != Fn.getJvm(null, () -> LocalDateTime.parse(literal, formatter), new Object[]{literal})).findAny(), literal);
        return hit.isPresent() ? LocalDateTime.parse(literal, (DateTimeFormatter)hit.get()) : null;
    }

    public static LocalDate toDate(String literal) {
        Optional hit = Fn.get(Optional.empty(), () -> DATES.stream().filter(formatter -> null != Fn.getJvm(null, () -> LocalDate.parse(literal, formatter), new Object[]{literal})).findFirst(), literal);
        return hit.isPresent() ? LocalDate.parse(literal, (DateTimeFormatter)hit.get()) : null;
    }

    public static LocalTime toTime(String literal) {
        Optional hit = Fn.get(Optional.empty(), () -> TIMES.stream().filter(formatter -> null != Fn.getJvm(null, () -> LocalTime.parse(literal, formatter), new Object[]{literal})).findFirst(), literal);
        return hit.isPresent() ? LocalTime.parse(literal, (DateTimeFormatter)hit.get()) : null;
    }

    public static boolean isValid(String literal) {
        Date parsed = Period.parse(literal);
        return null != parsed;
    }

    public static Date parse(String literal) {
        return Fn.get(null, () -> {
            int length = literal.length();
            String pattern = (String)Storage.PATTERNS_MAP.get(length);
            if (null != pattern) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, Locale.US);
                Date converted = null;
                if (10 == pattern.length()) {
                    LocalDate date = LocalDate.parse(literal, formatter);
                    converted = Period.parse(date);
                } else if (15 > pattern.length()) {
                    LocalTime time = LocalTime.parse(literal, formatter);
                    converted = Period.parse(time);
                } else {
                    LocalDateTime datetime = LocalDateTime.parse(literal, formatter);
                    converted = Period.parse(datetime);
                }
                return converted;
            }
            return Period.parseFull(literal);
        }, new Object[]{literal});
    }

    public static Date parseFull(String literal) {
        return Fn.get(null, () -> {
            LocalDateTime datetime = Period.toFull(literal);
            return Fn.nullFlow(datetime, ref -> Date.from(ref.atZone(ZoneId.systemDefault()).toInstant()), () -> {
                LocalDate date = Period.toDate(literal);
                return Fn.nullFlow(date, ref -> Date.from(ref.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()), () -> {
                    LocalTime time = Period.toTime(literal);
                    return null == time ? null : Period.parse(time);
                });
            });
        }, new Object[]{literal});
    }

    public static boolean equalDate(Date left, Date right) {
        int rightVal;
        int leftVal = Period.toItem(left, 1);
        if (leftVal == (rightVal = Period.toItem(right, 1))) {
            leftVal = Period.toItem(left, 2);
            if (leftVal == (rightVal = Period.toItem(right, 2))) {
                leftVal = Period.toItem(left, 5);
                return leftVal == (rightVal = Period.toItem(right, 5));
            }
            return false;
        }
        return false;
    }

    public static int toMonth(String literal) {
        Date date = Period.parse(literal);
        return Period.toItem(date, 2);
    }

    public static int toMonth(Date date) {
        return Period.toItem(date, 2);
    }

    public static int toYear(Date date) {
        return Period.toItem(date, 1);
    }

    public static int toYear(String literal) {
        Date date = Period.parse(literal);
        return Period.toItem(date, 1);
    }

    private static int toItem(Date date, int flag) {
        Calendar issue = Calendar.getInstance();
        issue.setTime(date);
        return issue.get(flag);
    }

    public static Date parse(LocalTime time) {
        LocalDate date = LocalDate.now();
        LocalDateTime datetime = LocalDateTime.of(date, time);
        return Date.from(datetime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date parse(LocalDateTime datetime) {
        return Date.from(datetime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date parse(LocalDate datetime) {
        return Date.from(datetime.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    private Period() {
    }
}

