/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.func;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.exception.WebException;
import io.vertx.up.func.Actuator;
import io.vertx.up.func.Announce;
import io.vertx.up.func.Congregation;
import io.vertx.up.func.Defend;
import io.vertx.up.func.Deliver;
import io.vertx.up.func.JvmActuator;
import io.vertx.up.func.JvmSupplier;
import io.vertx.up.func.Pond;
import io.vertx.up.func.Semi;
import io.vertx.up.func.Zero;
import io.vertx.up.func.ZeroActuator;
import io.vertx.up.func.ZeroBiConsumer;
import io.vertx.up.func.ZeroSupplier;
import io.vertx.up.log.Annal;
import io.vertx.zero.exception.ZeroException;
import io.vertx.zero.exception.ZeroRunException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Fn {
    public static void flingZero(boolean condition, Annal logger, Class<? extends ZeroException> zeroClass, Object ... args) throws ZeroException {
        if (condition) {
            Announce.outZero(logger, zeroClass, args);
        }
    }

    public static void flingUp(ZeroActuator actuator, Annal logger) {
        Announce.toRun(logger, actuator);
    }

    public static void flingUp(boolean condition, Annal logger, Class<? extends ZeroRunException> upClass, Object ... args) {
        if (condition) {
            Announce.outUp(logger, upClass, args);
        }
    }

    public static void flingWeb(boolean condition, Annal logger, Class<? extends WebException> webClass, Object ... args) {
        if (condition) {
            Announce.outWeb(logger, webClass, args);
        }
    }

    public static void safeJvm(JvmActuator actuator, Annal logger) {
        Defend.jvmVoid(actuator, logger);
    }

    public static <T> T safeJvm(JvmSupplier<T> supplier, Annal logger) {
        return Defend.jvmReturn(supplier, logger);
    }

    public static <T> T safeZero(ZeroSupplier<T> supplier, Annal logger) {
        return Defend.zeroReturn(supplier, logger);
    }

    public static void safeZero(ZeroActuator actuator, Annal logger) {
        Defend.zeroVoid(actuator, logger);
    }

    public static void safeNull(Actuator actuator, Object ... input) {
        Zero.exec(actuator, input);
    }

    public static <T> void safeNull(Consumer<T> consumer, T input) {
        Zero.exec(consumer, input);
    }

    public static void safeSemi(boolean condition, Annal logger, Actuator tSupplier, Actuator fSupplier) {
        Semi.exec(condition, logger, tSupplier, fSupplier);
    }

    public static void safeSemi(boolean condition, Annal logger, Actuator tSupplier) {
        Semi.exec(condition, logger, tSupplier, null);
    }

    public static <T> T transRun(Supplier<T> supplier, Class<? extends ZeroRunException> runCls, Object ... args) {
        return Deliver.execRun(supplier, runCls, args);
    }

    public static void shuntRun(Actuator actuator, Annal logger) {
        Announce.shuntRun(actuator, logger);
    }

    public static void shuntZero(ZeroActuator actuator, Object ... input) throws ZeroException {
        Zero.execZero(actuator, input);
    }

    public static <T> T getJvm(JvmSupplier<T> supplier, Object ... input) {
        return Zero.getJvm(null, supplier, input);
    }

    public static <T> T get(Supplier<T> supplier, Object ... input) {
        return Zero.get(null, supplier, input);
    }

    public static <T> T getSemi(boolean condition, Annal logger, Supplier<T> tSupplier, Supplier<T> fSupplier) {
        return (T)Defend.zeroReturn(() -> Semi.execZero(condition, ((Supplier)tSupplier)::get, ((Supplier)fSupplier)::get), logger);
    }

    public static <T> T getSemi(boolean condition, Annal logger, Supplier<T> tSupplier) {
        return (T)Defend.zeroReturn(() -> Semi.execZero(condition, ((Supplier)tSupplier)::get, null), logger);
    }

    public static <T> T getSemi(boolean condition, ZeroSupplier<T> tSupplier, ZeroSupplier<T> fSupplier) throws ZeroException {
        return Semi.execZero(condition, tSupplier, fSupplier);
    }

    public static <T> T get(T defaultValue, Supplier<T> supplier, Object ... input) {
        return Zero.get(defaultValue, supplier, input);
    }

    public static <T> T getJvm(T defaultValue, JvmSupplier<T> supplier, Object ... input) {
        return Zero.getJvm(defaultValue, supplier, input);
    }

    public static <K, V> void itMap(ConcurrentMap<K, V> map, BiConsumer<K, V> fnEach) {
        Congregation.exec(map, fnEach);
    }

    public static <V> void itSet(Set<V> set, BiConsumer<V, Integer> fnEach) {
        ArrayList<V> list = new ArrayList<V>(set);
        Congregation.exec(list, fnEach);
    }

    public static <V> void itList(List<V> list, BiConsumer<V, Integer> fnEach) {
        Congregation.exec(list, fnEach);
    }

    public static <V> void itArray(V[] array, BiConsumer<V, Integer> fnEach) {
        Congregation.exec(Arrays.asList(array), fnEach);
    }

    public static <V> void itMatrix(V[][] array, Consumer<V> fnEach) {
        Congregation.exec(array, fnEach);
    }

    public static <T> void itJObject(JsonObject data, BiConsumer<T, String> fnEach) {
        Congregation.exec(data, fnEach);
    }

    public static <T> void etJObject(JsonObject data, ZeroBiConsumer<T, String> fnIt) throws ZeroException {
        Congregation.execZero(data, fnIt);
    }

    public static <T> void itJArray(JsonArray array, Class<T> clazz, BiConsumer<T, Integer> fnEach) {
        Congregation.exec(array, clazz, fnEach);
    }

    public static <T> void etJArray(JsonArray dataArray, Class<T> clazz, ZeroBiConsumer<T, Integer> fnIt) throws ZeroException {
        Congregation.execZero(dataArray, clazz, fnIt);
    }

    public static <T> void etJArray(JsonArray dataArray, ZeroBiConsumer<T, String> fnIt) throws ZeroException {
        Congregation.execZero(dataArray, fnIt);
    }

    public static <K, V> V pool(ConcurrentMap<K, V> pool, K key, Supplier<V> poolFn) {
        return Pond.exec(pool, key, poolFn);
    }

    public static <V> V poolThread(ConcurrentMap<String, V> pool, Supplier<V> poolFn) {
        String threadName = Thread.currentThread().getName();
        return Pond.exec(pool, threadName, poolFn);
    }

    public static <K, V, E> ConcurrentMap<K, List<V>> packet(Collection<E> object, Function<E, K> keyFn, Function<E, V> valueFn) {
        return Pond.group(object, keyFn, valueFn);
    }

    public static <K, V, E> ConcurrentMap<K, V> zipper(E[] object, Function<E, K> keyFn, Function<E, V> valueFn) {
        return Pond.zipper(Arrays.asList(object), keyFn, valueFn);
    }

    public static <K, V, E> ConcurrentMap<K, V> zipper(Collection<E> object, Function<E, K> keyFn, Function<E, V> valueFn) {
        return Pond.zipper(object, keyFn, valueFn);
    }

    public static <T, F> T nullFlow(F reference, Function<F, T> tranFn, Supplier<T> supplier) {
        return Zero.nullFlow(reference, tranFn, supplier);
    }

    public static <T> T nil() {
        return null;
    }
}

