/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.func;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.func.ZeroBiConsumer;
import io.vertx.up.log.Annal;
import io.vertx.zero.exception.ZeroException;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

class Congregation {
    private static final Annal LOGGER = Annal.get(Congregation.class);

    Congregation() {
    }

    static <K, V> void exec(ConcurrentMap<K, V> map, BiConsumer<K, V> fnEach) {
        map.forEach((key, value) -> {
            if (null != key && null != value) {
                fnEach.accept(key, value);
            }
        });
    }

    static <V> void exec(List<V> list, BiConsumer<V, Integer> fnEach) {
        int size = list.size();
        for (int idx = 0; idx < size; ++idx) {
            V item = list.get(idx);
            if (null == item) continue;
            fnEach.accept(item, idx);
        }
    }

    static <V> void exec(V[][] matrix, Consumer<V> fnEach) {
        V[][] VArray = matrix;
        int n = VArray.length;
        for (int i = 0; i < n; ++i) {
            V[] arr;
            for (V item : arr = VArray[i]) {
                if (null == item) continue;
                fnEach.accept(item);
            }
        }
    }

    static <T> void exec(JsonObject data, BiConsumer<T, String> fnEach) {
        try {
            Congregation.execZero(data, fnEach::accept);
        }
        catch (ZeroException ex) {
            LOGGER.jvm(ex);
        }
    }

    static <T> void execZero(JsonObject data, ZeroBiConsumer<T, String> fnIt) throws ZeroException {
        for (String name : data.fieldNames()) {
            Object item = data.getValue(name);
            if (null == item) continue;
            fnIt.accept(item, name);
        }
    }

    static <T> void exec(JsonArray dataArray, Class<T> clazz, BiConsumer<T, Integer> fnEach) {
        try {
            Congregation.execZero(dataArray, clazz, fnEach::accept);
        }
        catch (ZeroException ex) {
            LOGGER.jvm(ex);
        }
    }

    static <T> void execZero(JsonArray dataArray, ZeroBiConsumer<T, String> fnIt) throws ZeroException {
        Congregation.execZero(dataArray, JsonObject.class, (element, index) -> Congregation.execZero(element, fnIt::accept));
    }

    static <T> void execZero(JsonArray dataArray, Class<T> clazz, ZeroBiConsumer<T, Integer> fnIt) throws ZeroException {
        int size = dataArray.size();
        for (int idx = 0; idx < size; ++idx) {
            Object value = dataArray.getValue(idx);
            if (null == value || clazz != value.getClass()) continue;
            Object item = value;
            fnIt.accept(item, idx);
        }
    }
}

