/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.exception;

import io.vertx.core.http.HttpStatusCode;
import io.vertx.core.json.JsonObject;
import io.vertx.up.tool.StringUtil;
import io.vertx.zero.exception.ZeroRunException;
import io.vertx.zero.log.Errors;

public abstract class WebException
extends ZeroRunException {
    protected static final String MESSAGE = "message";
    protected static final String INFO = "info";
    protected static final String CODE = "code";
    private final String message;
    protected HttpStatusCode status;
    private String readible;

    public WebException(String message) {
        super(message);
        this.message = message;
        this.status = HttpStatusCode.BAD_REQUEST;
    }

    public WebException(Class<?> clazz, Object ... args) {
        super("");
        this.message = Errors.normalizeWeb(clazz, this.getCode(), args);
        this.status = HttpStatusCode.BAD_REQUEST;
    }

    public abstract int getCode();

    public String getMessage() {
        return this.message;
    }

    public HttpStatusCode getStatus() {
        return this.status;
    }

    public void setReadible(String readible) {
        this.readible = readible;
    }

    public void setStatus(HttpStatusCode status) {
        this.status = status;
    }

    public String getReadible() {
        return this.readible;
    }

    public JsonObject toJson() {
        JsonObject data = new JsonObject();
        data.put(CODE, Integer.valueOf(this.getCode()));
        data.put(MESSAGE, this.getMessage());
        if (StringUtil.notNil(this.readible)) {
            data.put(INFO, this.readible);
        }
        return data;
    }
}

