/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.concurrent;

import io.vertx.up.concurrent.Routine;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;

public final class Runner {
    private static final Annal LOGGER = Annal.get(Runner.class);

    public static void run(Runnable hooker, String name) {
        Thread thread = new Thread(hooker);
        thread.setName(name);
        thread.start();
    }

    public static <T> void run(List<Routine<T>> routines, ConcurrentMap<String, T> result) {
        ArrayList<Thread> references = new ArrayList<Thread>();
        for (Routine<T> routine : routines) {
            Thread thread = new Thread(routine);
            references.add(thread);
            thread.start();
        }
        references.forEach(item -> {
            try {
                item.join();
            }
            catch (InterruptedException ex) {
                LOGGER.jvm(ex);
            }
        });
        for (Routine<T> routine : routines) {
            String key = routine.getKey();
            Object value = routine.get();
            Fn.safeNull(() -> result.put(key, value), key, value);
        }
    }
}

