/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.aiki;

import io.reactivex.Observable;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.tool.Statute;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class Dual {
    Dual() {
    }

    static JsonObject append(JsonObject target, JsonObject source, boolean immutable) {
        JsonObject result = immutable ? target.copy() : target;
        Observable.fromIterable((Iterable)source.fieldNames()).filter(key -> !target.containsKey(key)).subscribe(key -> result.put(key, source.getValue(key)));
        return result;
    }

    static JsonObject append(JsonObject target, JsonArray sources) {
        Observable.fromIterable((Iterable)sources).map(item -> (JsonObject)item).subscribe(item -> Dual.append(target, item, false));
        return target;
    }

    static JsonArray zip(JsonArray target, JsonArray sources, String fromKey, String toKey) {
        ConcurrentMap<Integer, Object> targetMap = Dual.mapIndex(target, fromKey);
        ConcurrentMap<Object, JsonObject> sourceMap = Dual.mapZip(sources, toKey);
        ConcurrentMap<Integer, JsonObject> merged = Statute.reduce(targetMap, sourceMap);
        JsonArray results = new JsonArray();
        for (int idx = 0; idx < target.size(); ++idx) {
            JsonObject targetItem = (JsonObject)merged.get(idx);
            JsonObject sourceItem = target.getJsonObject(idx);
            JsonObject item = null == targetItem ? sourceItem : Dual.append(sourceItem, targetItem, true);
            results.add(item);
        }
        target.clear();
        return target.addAll(results);
    }

    private static ConcurrentMap<Object, JsonObject> mapZip(JsonArray sources, String field) {
        ConcurrentHashMap<Object, JsonObject> resultMap = new ConcurrentHashMap<Object, JsonObject>();
        Observable.fromIterable((Iterable)sources).map(item -> (JsonObject)item).subscribe(item -> {
            Object value;
            if (item.containsKey(field) && null != (value = item.getValue(field))) {
                resultMap.put(value, (JsonObject)item);
            }
        });
        return resultMap;
    }

    private static ConcurrentMap<Integer, Object> mapIndex(JsonArray sources, String field) {
        ConcurrentHashMap<Integer, Object> resultMap = new ConcurrentHashMap<Integer, Object>();
        for (int idx = 0; idx < sources.size(); ++idx) {
            JsonObject item = sources.getJsonObject(idx);
            Object value = item.getValue(field);
            if (null == value) continue;
            resultMap.put(idx, value);
        }
        return resultMap;
    }
}

