/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.quiz;

import io.vertx.config.ConfigRetriever;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.config.ConfigStoreOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.quiz.ZeroBase;
import io.vertx.up.tool.Store;

public abstract class StoreBase
extends ZeroBase {
    protected void execJObject(String filename, Handler<AsyncResult<JsonObject>> handler) {
        ConfigStoreOptions options = Store.getJson(this.getFile(filename));
        this.exec(options, handler);
    }

    protected void execYaml(String filename, Handler<AsyncResult<JsonObject>> handler) {
        ConfigStoreOptions options = Store.getYaml(this.getFile(filename));
        this.exec(options, handler);
    }

    protected void execProp(String filename, Handler<AsyncResult<JsonObject>> handler) {
        ConfigStoreOptions options = Store.getProp(this.getFile(filename));
        this.exec(options, handler);
    }

    private void exec(ConfigStoreOptions options, Handler<AsyncResult<JsonObject>> handler) {
        ConfigRetrieverOptions retrieverOptions = new ConfigRetrieverOptions().addStore(options);
        Vertx vertx = this.rule.vertx();
        ConfigRetriever retriever = ConfigRetriever.create((Vertx)vertx, (ConfigRetrieverOptions)retrieverOptions);
        retriever.getConfig(handler);
    }
}

