require 'vertx-web-api-contract/design_driven_router_factory'
require 'vertx/vertx'
require 'vertx-web/router'
require 'vertx-web/routing_context'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory
module VertxWebApiContract
  #  Interface for OpenAPI3RouterFactory. <br/>
  #  To add an handler, use {::VertxWebApiContract::OpenAPI3RouterFactory#add_handler_by_operation_id}, in this
  #  class is better than generic <br/>
  #  If you want to use  remember that <b>you have to pass path as declared in openapi specification</b>
  #  Usage example:
  #  <pre>
  #  <code>OpenAPI3RouterFactory.createRouterFactoryFromFile(vertx, "src/resources/spec.yaml", asyncResult -> {
  if (!asyncResult.succeeded()) {
     // IO failure or spec invalid</code> else {
  #      OpenAPI3RouterFactory routerFactory = asyncResult.result();
  #      routerFactory.addHandlerByOperationId("operation_id", routingContext -> {
  #         // Do something
  #      }, routingContext -> {
  #         // Do something with failure handler
  #      });
  #      Router router = routerFactory.getRouter();
  #   }
  #  });
  #  }
  #  </pre>
  class OpenAPI3RouterFactory
    include ::VertxWebApiContract::DesignDrivenRouterFactory
    # @private
    # @param j_del [::VertxWebApiContract::OpenAPI3RouterFactory] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebApiContract::OpenAPI3RouterFactory] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == OpenAPI3RouterFactory
    end
    def @@j_api_type.wrap(obj)
      OpenAPI3RouterFactory.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebApiContractOpenapi3::OpenAPI3RouterFactory.java_class
    end
    #  Mount to paths that have to follow a security schema a security handler
    # @param [String] securitySchemaName 
    # @yield 
    # @return [self]
    def add_security_handler(securitySchemaName=nil)
      if securitySchemaName.class == String && block_given?
        @j_del.java_method(:addSecurityHandler, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(securitySchemaName,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_security_handler(#{securitySchemaName})"
    end
    #  Add an handler to a path with a method. If combination path/method is not available in
    #  specification, it will throw a 
    # @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    # @param [String] path 
    # @yield 
    # @return [self]
    def add_handler(method=nil,path=nil)
      if method.class == Symbol && path.class == String && block_given?
        @j_del.java_method(:addHandler, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(method.to_s),path,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_handler(#{method},#{path})"
    end
    #  Add a failure handler to a path with a method. If combination path/method is not available in
    #  specification, it will throw a 
    # @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    # @param [String] path 
    # @yield 
    # @return [self]
    def add_failure_handler(method=nil,path=nil)
      if method.class == Symbol && path.class == String && block_given?
        @j_del.java_method(:addFailureHandler, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(method.to_s),path,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_failure_handler(#{method},#{path})"
    end
    #  Set default validation failure handler. You can disable this feature from
    #  
    # @yield 
    # @return [self]
    def set_validation_failure_handler
      if block_given?
        @j_del.java_method(:setValidationFailureHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_validation_failure_handler()"
    end
    #  Enable or disable validation failure handler. If you enable it, during router creation it will be mounted a
    #  built-in (or custom with function )
    #  ValidationException handler as a failure handler. If failure is different from ValidationException, it will be
    #  called the next failure handler.
    # @param [true,false] enable 
    # @return [self]
    def enable_validation_failure_handler(enable=nil)
      if (enable.class == TrueClass || enable.class == FalseClass) && !block_given?
        @j_del.java_method(:enableValidationFailureHandler, [Java::boolean.java_class]).call(enable)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling enable_validation_failure_handler(#{enable})"
    end
    #  Automatic mount handlers that return HTTP 501 status code for operations where you didn't specify an handler.
    # @param [true,false] enable 
    # @return [self]
    def mount_operations_without_handlers(enable=nil)
      if (enable.class == TrueClass || enable.class == FalseClass) && !block_given?
        @j_del.java_method(:mountOperationsWithoutHandlers, [Java::boolean.java_class]).call(enable)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling mount_operations_without_handlers(#{enable})"
    end
    #  Construct a new router based on spec. It will fail if you are trying to mount a spec with security schemes
    #  without assigned handlers<br/>
    #  <b>Note:</b> Router is constructed in this function, so it will be respected the path definition ordering.
    # @return [::VertxWeb::Router] 
    def get_router
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getRouter, []).call(),::VertxWeb::Router)
      end
      raise ArgumentError, "Invalid arguments when calling get_router()"
    end
    #  Add a particular scope validator. The main security schema will not be called if a specific scope validator is
    #  configured
    # @param [String] securitySchemaName 
    # @param [String] scopeName 
    # @yield 
    # @return [self]
    def add_security_schema_scope_validator(securitySchemaName=nil,scopeName=nil)
      if securitySchemaName.class == String && scopeName.class == String && block_given?
        @j_del.java_method(:addSecuritySchemaScopeValidator, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(securitySchemaName,scopeName,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_security_schema_scope_validator(#{securitySchemaName},#{scopeName})"
    end
    #  Add an handler by operation_id field in Operation object
    # @param [String] operationId 
    # @yield 
    # @return [self]
    def add_handler_by_operation_id(operationId=nil)
      if operationId.class == String && block_given?
        @j_del.java_method(:addHandlerByOperationId, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(operationId,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_handler_by_operation_id(#{operationId})"
    end
    #  Add a failure handler by operation_id field in Operation object
    # @param [String] operationId 
    # @yield 
    # @return [self]
    def add_failure_handler_by_operation_id(operationId=nil)
      if operationId.class == String && block_given?
        @j_del.java_method(:addFailureHandlerByOperationId, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(operationId,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_failure_handler_by_operation_id(#{operationId})"
    end
    #  Create a new OpenAPI3RouterFactory from a filename
    # @param [::Vertx::Vertx] vertx 
    # @param [String] filename 
    # @yield When specification is loaded, this handler will be called with AsyncResult<OpenAPI3RouterFactory>
    # @return [void]
    def self.create_router_factory_from_file(vertx=nil,filename=nil)
      if vertx.class.method_defined?(:j_del) && filename.class == String && block_given?
        return Java::IoVertxExtWebApiContractOpenapi3::OpenAPI3RouterFactory.java_method(:createRouterFactoryFromFile, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(vertx.j_del,filename,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebApiContract::OpenAPI3RouterFactory) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling create_router_factory_from_file(#{vertx},#{filename})"
    end
    #  Create a new OpenAPI3RouterFactory from an url
    # @param [::Vertx::Vertx] vertx 
    # @param [String] url 
    # @yield When specification is loaded, this handler will be called with AsyncResult<OpenAPI3RouterFactory>
    # @return [void]
    def self.create_router_factory_from_url(vertx=nil,url=nil)
      if vertx.class.method_defined?(:j_del) && url.class == String && block_given?
        return Java::IoVertxExtWebApiContractOpenapi3::OpenAPI3RouterFactory.java_method(:createRouterFactoryFromURL, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(vertx.j_del,url,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWebApiContract::OpenAPI3RouterFactory) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling create_router_factory_from_url(#{vertx},#{url})"
    end
  end
end
