require 'vertx-web/router'
require 'vertx-web/routing_context'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.api.contract.DesignDrivenRouterFactory
module VertxWebApiContract
  module DesignDrivenRouterFactory
    #  Mount to paths that have to follow a security schema a security handler
    # @param [String] securitySchemaName 
    # @yield 
    # @return [self]
    def add_security_handler(securitySchemaName=nil)
      if securitySchemaName.class == String && block_given?
        @j_del.java_method(:addSecurityHandler, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(securitySchemaName,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_security_handler(#{securitySchemaName})"
    end
    #  Add an handler to a path with a method. If combination path/method is not available in
    #  specification, it will throw a {Nil}
    # @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    # @param [String] path 
    # @yield 
    # @return [self]
    def add_handler(method=nil,path=nil)
      if method.class == Symbol && path.class == String && block_given?
        @j_del.java_method(:addHandler, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(method.to_s),path,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_handler(#{method},#{path})"
    end
    #  Add a failure handler to a path with a method. If combination path/method is not available in
    #  specification, it will throw a {Nil}
    # @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    # @param [String] path 
    # @yield 
    # @return [self]
    def add_failure_handler(method=nil,path=nil)
      if method.class == Symbol && path.class == String && block_given?
        @j_del.java_method(:addFailureHandler, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(method.to_s),path,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_failure_handler(#{method},#{path})"
    end
    #  Set default validation failure handler. You can disable this feature from
    #  {::VertxWebApiContract::DesignDrivenRouterFactory#enable_validation_failure_handler}
    # @yield 
    # @return [self]
    def set_validation_failure_handler
      if block_given?
        @j_del.java_method(:setValidationFailureHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_validation_failure_handler()"
    end
    #  Enable or disable validation failure handler. If you enable it, during router creation it will be mounted a
    #  built-in (or custom with function {::VertxWebApiContract::DesignDrivenRouterFactory#set_validation_failure_handler})
    #  ValidationException handler as a failure handler. If failure is different from ValidationException, it will be
    #  called the next failure handler.
    # @param [true,false] enable 
    # @return [self]
    def enable_validation_failure_handler(enable=nil)
      if (enable.class == TrueClass || enable.class == FalseClass) && !block_given?
        @j_del.java_method(:enableValidationFailureHandler, [Java::boolean.java_class]).call(enable)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling enable_validation_failure_handler(#{enable})"
    end
    #  Automatic mount handlers that return HTTP 501 status code for operations where you didn't specify an handler.
    # @param [true,false] enable 
    # @return [self]
    def mount_operations_without_handlers(enable=nil)
      if (enable.class == TrueClass || enable.class == FalseClass) && !block_given?
        @j_del.java_method(:mountOperationsWithoutHandlers, [Java::boolean.java_class]).call(enable)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling mount_operations_without_handlers(#{enable})"
    end
    #  Construct a new router based on spec. It will fail if you are trying to mount a spec with security schemes
    #  without assigned handlers<br/>
    #  <b>Note:</b> Router is constructed in this function, so it will be respected the path definition ordering.
    # @return [::VertxWeb::Router] 
    def get_router
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getRouter, []).call(),::VertxWeb::Router)
      end
      raise ArgumentError, "Invalid arguments when calling get_router()"
    end
  end
  class DesignDrivenRouterFactoryImpl
    include DesignDrivenRouterFactory
    # @private
    # @param j_del [::VertxWebApiContract::DesignDrivenRouterFactory] the java delegate
    def initialize(j_del, j_arg_Specification=nil)
      @j_del = j_del
      @j_arg_Specification = j_arg_Specification != nil ? j_arg_Specification : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::VertxWebApiContract::DesignDrivenRouterFactory] the underlying java delegate
    def j_del
      @j_del
    end
  end
end
