/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-api-contract-js/design_driven_router_factory */
var utils = require('vertx-js/util/utils');
var Router = require('vertx-web-js/router');
var RoutingContext = require('vertx-web-js/routing_context');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JDesignDrivenRouterFactory = Java.type('io.vertx.ext.web.api.contract.DesignDrivenRouterFactory');

/**
 Main interface for Design Driven Router factory
 @class
*/
var DesignDrivenRouterFactory = function(j_val, j_arg_0) {

  var j_designDrivenRouterFactory = j_val;
  var that = this;
  var j_Specification = typeof j_arg_0 !== 'undefined' ? j_arg_0 : utils.unknown_jtype;

  /**
   Mount to paths that have to follow a security schema a security handler

   @public
   @param securitySchemaName {string} 
   @param handler {function} 
   @return {DesignDrivenRouterFactory} 
   */
  this.addSecurityHandler = function(securitySchemaName, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_designDrivenRouterFactory["addSecurityHandler(java.lang.String,io.vertx.core.Handler)"](securitySchemaName, function(jVal) {
      handler(utils.convReturnVertxGen(RoutingContext, jVal));
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add an handler to a path with a method. If combination path/method is not available in
   specification, it will throw a {@link RouterFactoryException}

   @public
   @param method {Object} 
   @param path {string} 
   @param handler {function} 
   @return {DesignDrivenRouterFactory} 
   */
  this.addHandler = function(method, path, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_designDrivenRouterFactory["addHandler(io.vertx.core.http.HttpMethod,java.lang.String,io.vertx.core.Handler)"](io.vertx.core.http.HttpMethod.valueOf(method), path, function(jVal) {
      handler(utils.convReturnVertxGen(RoutingContext, jVal));
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a failure handler to a path with a method. If combination path/method is not available in
   specification, it will throw a {@link RouterFactoryException}

   @public
   @param method {Object} 
   @param path {string} 
   @param failureHandler {function} 
   @return {DesignDrivenRouterFactory} 
   */
  this.addFailureHandler = function(method, path, failureHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_designDrivenRouterFactory["addFailureHandler(io.vertx.core.http.HttpMethod,java.lang.String,io.vertx.core.Handler)"](io.vertx.core.http.HttpMethod.valueOf(method), path, function(jVal) {
      failureHandler(utils.convReturnVertxGen(RoutingContext, jVal));
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set default validation failure handler. You can disable this feature from
   {@link DesignDrivenRouterFactory#enableValidationFailureHandler}

   @public
   @param handler {function} 
   @return {DesignDrivenRouterFactory} 
   */
  this.setValidationFailureHandler = function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_designDrivenRouterFactory["setValidationFailureHandler(io.vertx.core.Handler)"](function(jVal) {
      handler(utils.convReturnVertxGen(RoutingContext, jVal));
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Enable or disable validation failure handler. If you enable it, during router creation it will be mounted a
   built-in (or custom with function {@link DesignDrivenRouterFactory#setValidationFailureHandler})
   ValidationException handler as a failure handler. If failure is different from ValidationException, it will be
   called the next failure handler.

   @public
   @param enable {boolean} 
   @return {DesignDrivenRouterFactory} 
   */
  this.enableValidationFailureHandler = function(enable) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      j_designDrivenRouterFactory["enableValidationFailureHandler(boolean)"](enable);
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Automatic mount handlers that return HTTP 501 status code for operations where you didn't specify an handler.

   @public
   @param enable {boolean} 
   @return {DesignDrivenRouterFactory} 
   */
  this.mountOperationsWithoutHandlers = function(enable) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      j_designDrivenRouterFactory["mountOperationsWithoutHandlers(boolean)"](enable);
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Construct a new router based on spec. It will fail if you are trying to mount a spec with security schemes
   without assigned handlers<br/>
   <b>Note:</b> Router is constructed in this function, so it will be respected the path definition ordering.

   @public

   @return {Router} 
   */
  this.getRouter = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Router, j_designDrivenRouterFactory["getRouter()"]());
    } else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_designDrivenRouterFactory;
};

DesignDrivenRouterFactory._jclass = utils.getJavaClass("io.vertx.ext.web.api.contract.DesignDrivenRouterFactory");
DesignDrivenRouterFactory._jtype = {
  accept: function(obj) {
    return DesignDrivenRouterFactory._jclass.isInstance(obj._jdel);
  },
  wrap: function(jdel) {
    var obj = Object.create(DesignDrivenRouterFactory.prototype, {});
    DesignDrivenRouterFactory.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
DesignDrivenRouterFactory._create = function(jdel) {
  var obj = Object.create(DesignDrivenRouterFactory.prototype, {});
  DesignDrivenRouterFactory.apply(obj, arguments);
  return obj;
}
module.exports = DesignDrivenRouterFactory;