/*
 * Decompiled with CFR 0.152.
 */
package cn.originx.infix.oracle12;

import cn.originx.infix.oracle12.cv.OracleStatement;
import cn.originx.infix.oracle12.cv.OracleWord;
import cn.vertxup.atom.domain.tables.pojos.MField;
import com.hazelcast.internal.util.StringUtil;
import io.vertx.tp.modular.jdbc.DataConnection;
import io.vertx.tp.modular.metadata.AbstractSentence;
import io.vertx.up.commune.config.Database;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class OracleSentence
extends AbstractSentence
implements OracleStatement,
OracleWord {
    private static final ConcurrentMap<String, String> PRECISION_MAP = new ConcurrentHashMap<String, String>();
    private static final ConcurrentMap<String, String> LENGTH_MAP = new ConcurrentHashMap<String, String>();

    OracleSentence(Database database) {
        super(database);
    }

    public ConcurrentMap<String, String> getPrecisionMap() {
        return PRECISION_MAP;
    }

    public ConcurrentMap<String, String> getLengthMap() {
        return LENGTH_MAP;
    }

    public String expectTable(String tableName) {
        return MessageFormat.format("SELECT COUNT(*) FROM ALL_TABLES WHERE OWNER=''{0}'' AND TABLE_NAME=''{1}''", this.database.getInstance(), tableName);
    }

    public String columnDdl(String column) {
        return "\"" + column + "\"";
    }

    public String segmentField(MField field) {
        StringBuilder segment = new StringBuilder(this.defineColumn(field));
        if (!field.getIsNullable().booleanValue() || field.getIsPrimary().booleanValue()) {
            segment.append("NOT").append(" ").append("NULL");
        } else {
            segment.append("NULL");
        }
        return segment.toString();
    }

    protected String getType(MField field) {
        String rawType;
        StringBuilder type = new StringBuilder();
        String actualType = rawType = this.typeProvider.getColumnType(field.getColumnType());
        type.append(this.defineSuffix(field, actualType));
        return type.toString();
    }

    private Boolean updateNullable(String tableName, MField field) {
        DataConnection conn = new DataConnection(this.database);
        String sql = MessageFormat.format("SELECT NULLABLE FROM DBA_TAB_COLUMNS WHERE OWNER=''{0}'' AND TABLE_NAME=''{1}'' AND COLUMN_NAME=''{2}''", conn.getDatabase().getInstance(), tableName, field.getColumnName());
        List nullable = conn.select(sql, "NULLABLE");
        String result = (String)nullable.get(0);
        return StringUtil.equalsIgnoreCase((String)result, (String)"Y") && field.getIsNullable() != false || StringUtil.equalsIgnoreCase((String)result, (String)"N") && field.getIsNullable() == false ? Boolean.FALSE : Boolean.TRUE;
    }

    public String constraintDrop(String tableName, String constraintName) {
        return MessageFormat.format("ALTER TABLE {0} DROP CONSTRAINT {1};", tableName, constraintName);
    }

    public String columnAlter(String tableName, MField field) {
        StringBuilder segment = new StringBuilder(this.defineColumn(field));
        if (this.updateNullable(tableName, field).booleanValue()) {
            if (!field.getIsNullable().booleanValue()) {
                segment.append("NOT").append(" ").append("NULL");
            } else {
                segment.append("NULL");
            }
        }
        return MessageFormat.format("ALTER TABLE {0} MODIFY {1};", tableName, segment.toString());
    }

    static {
        PRECISION_MAP.put("FLOAT", "FLOAT({0})");
        PRECISION_MAP.put("NUMBER", "NUMBER({0},{1})");
        LENGTH_MAP.put("CHAR", "CHAR({0})");
        LENGTH_MAP.put("NCHAR", "NCHAR({0})");
        LENGTH_MAP.put("VARCHAR2", "VARCHAR2({0})");
        LENGTH_MAP.put("NVARCHAR2", "NVARCHAR2({0})");
        LENGTH_MAP.put("RAW", "RAW({0})");
        LENGTH_MAP.put("NUMBER", "NUMBER({0})");
    }
}

