/*
 * Decompiled with CFR 0.152.
 */
package cn.originx.infix.oracle12;

import cn.originx.infix.oracle12.cv.OracleStatement;
import cn.originx.infix.oracle12.cv.OracleWord;
import io.vertx.tp.atom.cv.em.KeyType;
import io.vertx.tp.modular.jdbc.AoConnection;
import io.vertx.tp.modular.metadata.AbstractReflector;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class OracleReflector
extends AbstractReflector
implements OracleStatement,
OracleWord {
    OracleReflector(AoConnection connection) {
        super(connection);
    }

    public ConcurrentMap<String, KeyType> getConstraints(String tableName) {
        ConcurrentHashMap<String, KeyType> constraints = new ConcurrentHashMap<String, KeyType>();
        String sql = MessageFormat.format("SELECT DISTINCT CONSTRAINT_NAME, CONSTRAINT_TYPE FROM USER_CONSTRAINTS WHERE OWNER=''{0}'' AND TABLE_NAME=''{1}'' ORDER BY CONSTRAINT_NAME", this.connection.getDatabase().getInstance(), tableName);
        String[] cols = new String[]{"CONSTRAINT_NAME", "CONSTRAINT_TYPE"};
        List results = this.connection.select(sql, cols);
        results.forEach(row -> {
            Object type = row.get("CONSTRAINT_TYPE");
            if (null != type) {
                Object name = row.get("CONSTRAINT_NAME");
                if ("U".equalsIgnoreCase(type.toString())) {
                    constraints.put(name.toString(), KeyType.UNIQUE);
                } else if ("P".equalsIgnoreCase(type.toString())) {
                    constraints.put(name.toString(), KeyType.PRIMARY);
                }
            }
        });
        return constraints;
    }

    public <T> List<T> getColumns(String tableName) {
        String sql = MessageFormat.format("SELECT COLUMN_NAME FROM ALL_TAB_COLUMNS WHERE OWNER=''{0}'' AND TABLE_NAME=''{1}''", this.connection.getDatabase().getInstance(), tableName);
        return this.connection.select(sql, "COLUMN_NAME");
    }

    public List<ConcurrentMap<String, Object>> getColumnDetail(String tableName) {
        return new ArrayList<ConcurrentMap<String, Object>>();
    }
}

