/*
 * Decompiled with CFR 0.152.
 */
package cn.originx.infix.mysql5;

import cn.originx.infix.mysql5.cv.MySqlStatement;
import cn.originx.infix.mysql5.cv.MySqlWord;
import cn.vertxup.atom.domain.tables.pojos.MField;
import io.vertx.core.json.JsonArray;
import io.vertx.tp.atom.cv.em.CheckResult;
import io.vertx.tp.modular.metadata.AbstractSentence;
import io.vertx.up.commune.config.Database;
import java.text.MessageFormat;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MySqlSentence
extends AbstractSentence
implements MySqlStatement,
MySqlWord {
    private static final ConcurrentMap<String, String> PRECISION_MAP = new ConcurrentHashMap<String, String>();
    private static final ConcurrentMap<String, String> LENGTH_MAP = new ConcurrentHashMap<String, String>();

    MySqlSentence(Database database) {
        super(database);
    }

    public ConcurrentMap<String, String> getPrecisionMap() {
        return PRECISION_MAP;
    }

    public ConcurrentMap<String, String> getLengthMap() {
        return LENGTH_MAP;
    }

    public String expectTable(String tableName) {
        return MessageFormat.format("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE=''BASE TABLE'' AND TABLE_SCHEMA = ''{0}'' AND TABLE_NAME = ''{1}''", this.database.getInstance(), tableName);
    }

    public String constraintDrop(String tableName, String constraintName) {
        return MessageFormat.format("ALTER TABLE {0} DROP {1};", tableName, constraintName);
    }

    public String columnAlter(String tableName, MField field) {
        return MessageFormat.format("ALTER TABLE {0} MODIFY {1};", tableName, this.segmentField(field));
    }

    public String columnDropRename(String tableName, String column, String newColumn, String fieldType) {
        return MessageFormat.format("ALTER TABLE {0} CHANGE {1} {2} {3};", tableName, column, newColumn, fieldType);
    }

    public String columnDdl(String column) {
        return "`" + column + "`";
    }

    public CheckResult checkFieldType(MField field, ConcurrentMap<String, Object> columnDetail) {
        String scale;
        if (null == columnDetail) {
            return CheckResult.FAILED;
        }
        String metaDBType = this.columnType(field);
        String DBType = columnDetail.get("DATA_TYPE").toString();
        String length = columnDetail.get("CHARACTER_MAXIMUM_LENGTH").toString().equalsIgnoreCase("NULL") ? "0" : columnDetail.get("CHARACTER_MAXIMUM_LENGTH").toString();
        String precision = columnDetail.get("NUMERIC_PRECISION").toString().equalsIgnoreCase("NULL") ? "0" : columnDetail.get("NUMERIC_PRECISION").toString();
        String string = scale = columnDetail.get("NUMERIC_SCALE").toString().equalsIgnoreCase("NULL") ? "0" : columnDetail.get("NUMERIC_SCALE").toString();
        if (DBType.equalsIgnoreCase(metaDBType)) {
            if (DBType.equalsIgnoreCase("TEXT")) {
                return CheckResult.SKIP;
            }
            if (null != field.getLength() && null != field.getPrecision()) {
                if (field.getLength().equals(Integer.parseInt(precision)) && field.getPrecision().equals(Integer.parseInt(scale))) {
                    return CheckResult.SKIP;
                }
                return CheckResult.PASS;
            }
            if (null != field.getLength()) {
                if (field.getLength().equals(Integer.parseInt(length))) {
                    return CheckResult.SKIP;
                }
                return CheckResult.PASS;
            }
            return CheckResult.SKIP;
        }
        if (metaDBType.equalsIgnoreCase("BIT") && (DBType.equalsIgnoreCase("BIT") || DBType.equalsIgnoreCase("TINYINT"))) {
            return CheckResult.SKIP;
        }
        JsonArray mappingList = this.mappingList(DBType.toUpperCase());
        if (!mappingList.contains((Object)metaDBType.toUpperCase())) {
            return CheckResult.FAILED;
        }
        return CheckResult.PASS;
    }

    static {
        PRECISION_MAP.put("DECIMAL", "DECIMAL({0},{1})");
        PRECISION_MAP.put("NUMERIC", "NUMERIC({0},{1})");
        LENGTH_MAP.put("CHAR", "CHAR({0})");
        LENGTH_MAP.put("VARCHAR", "VARCHAR({0})");
        LENGTH_MAP.put("BINARY", "BINARY({0})");
        LENGTH_MAP.put("VARBINARY", "VARBINARY({0})");
    }
}

