/*
 * Decompiled with CFR 0.152.
 */
package cn.originx.infix.mysql5;

import cn.originx.infix.mysql5.cv.MySqlStatement;
import cn.originx.infix.mysql5.cv.MySqlWord;
import io.horizon.eon.em.modeler.KeyType;
import io.vertx.tp.modular.jdbc.AoConnection;
import io.vertx.tp.modular.metadata.AbstractReflector;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MySqlReflector
extends AbstractReflector
implements MySqlStatement,
MySqlWord {
    MySqlReflector(AoConnection connection) {
        super(connection);
    }

    public ConcurrentMap<String, KeyType> getConstraints(String tableName) {
        ConcurrentHashMap<String, KeyType> constraints = new ConcurrentHashMap<String, KeyType>();
        String sql = MessageFormat.format("SELECT CONSTRAINT_NAME,CONSTRAINT_TYPE FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE TABLE_SCHEMA=''{0}'' AND TABLE_NAME=''{1}'' ORDER BY CONSTRAINT_NAME", this.connection.getDatabase().getInstance(), tableName);
        String[] cols = new String[]{"CONSTRAINT_NAME", "CONSTRAINT_TYPE"};
        List results = this.connection.select(sql, cols);
        results.forEach(row -> {
            Object type = row.get("CONSTRAINT_TYPE");
            if (null != type) {
                Object name = row.get("CONSTRAINT_NAME");
                if ("UNIQUE".equalsIgnoreCase(type.toString())) {
                    constraints.put("KEY " + name.toString(), KeyType.UNIQUE);
                } else if ("PRIMARY KEY".equalsIgnoreCase(type.toString())) {
                    constraints.put("PRIMARY KEY", KeyType.PRIMARY);
                }
            }
        });
        return constraints;
    }

    public <T> List<T> getColumns(String tableName) {
        String sql = MessageFormat.format("SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA=''{0}'' AND TABLE_NAME=''{1}''", this.connection.getDatabase().getInstance(), tableName);
        return this.connection.select(sql, "COLUMN_NAME");
    }

    public List<ConcurrentMap<String, Object>> getColumnDetail(String tableName) {
        String sql = MessageFormat.format("SELECT COLUMN_NAME, DATA_TYPE, CHARACTER_MAXIMUM_LENGTH, NUMERIC_PRECISION, NUMERIC_SCALE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA=''{0}'' AND TABLE_NAME=''{1}''", this.connection.getDatabase().getInstance(), tableName);
        String[] cols = new String[]{"COLUMN_NAME", "DATA_TYPE", "CHARACTER_MAXIMUM_LENGTH", "NUMERIC_PRECISION", "NUMERIC_SCALE"};
        List results = this.connection.select(sql, cols);
        return results;
    }

    public String getFieldType(ConcurrentMap<String, Object> columnDetail) {
        String DBType = columnDetail.get("DATA_TYPE").toString();
        String length = columnDetail.get("CHARACTER_MAXIMUM_LENGTH").toString().equalsIgnoreCase("NULL") ? "0" : columnDetail.get("CHARACTER_MAXIMUM_LENGTH").toString();
        String precision = columnDetail.get("NUMERIC_PRECISION").toString().equalsIgnoreCase("NULL") ? "0" : columnDetail.get("NUMERIC_PRECISION").toString();
        String scale = columnDetail.get("NUMERIC_SCALE").toString().equalsIgnoreCase("NULL") ? "0" : columnDetail.get("NUMERIC_SCALE").toString();
        return switch (DBType.toUpperCase()) {
            case "VARCHAR", "CHAR" -> DBType + "(" + length + ")";
            case "DECIMAL", "NUMERIC" -> DBType + "(" + precision + "," + scale + ")";
            default -> DBType;
        };
    }

    public ConcurrentMap<String, Object> getColumnDetails(String column, List<ConcurrentMap<String, Object>> columnDetailList) {
        return columnDetailList.stream().filter(item -> {
            for (Map.Entry col : item.entrySet()) {
                if (!((String)col.getKey()).equalsIgnoreCase("COLUMN_NAME")) continue;
                return col.getValue().toString().equalsIgnoreCase(column);
            }
            return false;
        }).findFirst().orElse(new ConcurrentHashMap());
    }

    public String getDataTypeWord() {
        return "DATA_TYPE";
    }

    public String getLengthWord() {
        return "CHARACTER_MAXIMUM_LENGTH";
    }
}

