package cn.originx.infix.mysql5;

import cn.originx.infix.mysql5.cv.MySqlStatement;
import cn.originx.infix.mysql5.cv.MySqlWord;
import io.horizon.eon.em.modeler.KeyType;
import io.vertx.tp.modular.jdbc.AoConnection;
import io.vertx.tp.modular.metadata.AbstractReflector;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MySqlReflector extends AbstractReflector implements MySqlStatement, MySqlWord {


    MySqlReflector(final AoConnection connection) {
        super(connection);
    }

    @Override
    public ConcurrentMap<String, KeyType> getConstraints(final String tableName) {
        final ConcurrentMap<String, KeyType> constraints = new ConcurrentHashMap<>();
        final String sql = MessageFormat.format(MySqlStatement.R_CONSTRAINTS, this.connection.getDatabase().getInstance(), tableName);
        final String[] cols = {Metadata.CONSTRAINT_NAME, Metadata.CONSTRAINT_TYPE};
        final List<ConcurrentMap<String, Object>> results = this.connection.select(sql, cols);
        results.forEach(row -> {
            final Object type = row.get(Metadata.CONSTRAINT_TYPE);
            if (null != type) {
                final Object name = row.get(Metadata.CONSTRAINT_NAME);
                if ("UNIQUE".equalsIgnoreCase(type.toString())) {
                    // Unique约束名
                    constraints.put("KEY " + name.toString(), KeyType.UNIQUE);
                } else if ("PRIMARY KEY".equalsIgnoreCase(type.toString())) {
                    // 主键特殊约束名
                    constraints.put("PRIMARY KEY", KeyType.PRIMARY);
                }
            }
        });
        return constraints;
    }

    @Override
    public <T> List<T> getColumns(final String tableName) {
        final String sql = MessageFormat.format(MySqlStatement.R_COLUMNS, this.connection.getDatabase().getInstance(), tableName);
        return this.connection.select(sql, Metadata.COLUMN);
    }

    @Override
    public List<ConcurrentMap<String, Object>> getColumnDetail(final String tableName) {
        final String sql = MessageFormat.format(MySqlStatement.R_COLUMNS_DETAILS, this.connection.getDatabase().getInstance(), tableName);
        final String[] cols = {Metadata.COLUMN, Metadata.DATA_TYPE, Metadata.CHARACTER_LENGTH, Metadata.NUMERIC_PRECISION, Metadata.NUMERIC_SCALE};
        final List<ConcurrentMap<String, Object>> results = this.connection.select(sql, cols);
        return results;
    }

    @Override
    public String getFieldType(final ConcurrentMap<String, Object> columnDetail) {
        // 数据库真实信息
        final String DBType = columnDetail.get(Metadata.DATA_TYPE).toString();
        final String length = columnDetail.get(Metadata.CHARACTER_LENGTH).toString().equalsIgnoreCase("NULL") ? "0" : columnDetail.get(Metadata.CHARACTER_LENGTH).toString();
        final String precision = columnDetail.get(Metadata.NUMERIC_PRECISION).toString().equalsIgnoreCase("NULL") ? "0" : columnDetail.get(Metadata.NUMERIC_PRECISION).toString();
        final String scale = columnDetail.get(Metadata.NUMERIC_SCALE).toString().equalsIgnoreCase("NULL") ? "0" : columnDetail.get(Metadata.NUMERIC_SCALE).toString();
        final String result;
        switch (DBType.toUpperCase()) {
            case Type.VARCHAR:
            case Type.CHAR:
                result = DBType + "(" + length + ")";
                break;
            case Type.DECIAML:
            case Type.NUMERIC:
                result = DBType + "(" + precision + "," + scale + ")";
                break;
            default:
                result = DBType;
                break;
        }
        return result;
    }

    @Override
    public ConcurrentMap<String, Object> getColumnDetails(final String column, final List<ConcurrentMap<String, Object>> columnDetailList) {
        return columnDetailList
            .stream()
            .filter(item -> {
                for (Map.Entry<String, Object> col : item.entrySet()) {
                    if (col.getKey().equalsIgnoreCase(Metadata.COLUMN)) {
                        return col.getValue().toString().equalsIgnoreCase(column);
                    }
                }
                return false;
            })
            .findFirst().orElse(new ConcurrentHashMap<>());
    }

    @Override
    public String getDataTypeWord() {
        return Metadata.DATA_TYPE;
    }

    @Override
    public String getLengthWord() {
        return Metadata.CHARACTER_LENGTH;
    }
}
