/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.aeon;

import io.aeon.atom.HSwitcher;
import io.aeon.atom.config.HPlot;
import io.aeon.atom.iras.HAeon;
import io.aeon.atom.iras.HBoot;
import io.aeon.exception.heart.AeonConfigureException;
import io.aeon.exception.heart.AeonEnvironmentException;
import io.horizon.cloud.boot.HOn;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.up.fn.Fn;
import io.vertx.up.runtime.ZeroAnno;
import io.vertx.up.runtime.ZeroApplication;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Objects;

public class AeonApplication
extends ZeroApplication {
    private AeonApplication(Class<?> clazz) {
        super(clazz);
    }

    public static void run(Class<?> clazz, Object ... args) {
        ZeroAnno.meditate();
        new AeonApplication(clazz).run(args);
    }

    private Future<Boolean> configure(HAeon aeon, Vertx vertx) {
        ArrayList<Future> futures = new ArrayList<Future>();
        HBoot boot = aeon.inBoot();
        HOn up = (HOn)boot.pick(HOn.class, vertx);
        futures.add(up.configure(aeon));
        return Fn.combineB(futures);
    }

    protected void runInternal(Vertx vertx, Object ... args) {
        HAeon aeon = HSwitcher.aeon();
        this.configure(aeon, vertx).onComplete(res -> {
            if (res.succeeded()) {
                super.runInternal(vertx, args);
            } else {
                Throwable error = res.cause();
                if (Objects.nonNull(error)) {
                    error.printStackTrace();
                }
            }
        });
    }

    protected void runBefore() {
        super.runBefore();
        HAeon aeon = HSwitcher.aeon();
        Fn.out((Objects.isNull(aeon) || Objects.isNull(aeon.inPlot()) ? 1 : 0) != 0, AeonConfigureException.class, (Object[])new Object[]{this.upClazz});
        HPlot plot = aeon.inPlot();
        Fn.out((boolean)Ut.isNil((String)plot.getCloud()), AeonEnvironmentException.class, (Object[])new Object[]{this.upClazz});
    }
}

