/*
 * Decompiled with CFR 0.152.
 */
package cn.venny.qiniu.service.impl;

import cn.venny.qiniu.properties.QiNiuProperties;
import cn.venny.qiniu.service.QiNiuUploadService;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultQiNiuUploadServiceImpl
implements QiNiuUploadService {
    public static Logger log = LoggerFactory.getLogger(QiNiuUploadService.class);
    private static final String CHINESE_PATTERN = "[\u4e00-\u9fa5|\uff01|\uff0c|\u3002|\uff08|\uff09|\u300a|\u300b|\u201c|\u201d|\uff1f|\uff1a|\uff1b|\u3010|\u3011]";
    private Auth auth;
    private QiNiuProperties properties;
    private UploadManager uploadManager;
    private BucketManager bucketManager;

    public DefaultQiNiuUploadServiceImpl() {
    }

    public DefaultQiNiuUploadServiceImpl(Auth auth, QiNiuProperties properties, UploadManager uploadManager, BucketManager bucketManager) {
        this.auth = auth;
        this.properties = properties;
        this.uploadManager = uploadManager;
        this.bucketManager = bucketManager;
    }

    @Override
    public void upload(String finalKey, InputStream in) {
        try {
            Response response = this.uploadManager.put(in, (long)in.available(), finalKey, this.auth.uploadToken(this.properties.getBucket()), new StringMap(), null, true);
            if (log.isDebugEnabled()) {
                log.debug("upload {},fileSize:{},response:{}", new Object[]{finalKey, in.available(), response});
            }
            if (200 == response.statusCode) {
                return;
            }
            throw new RuntimeException(response.getInfo());
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error("upload image/video to qi niu cloud has error", (Throwable)e);
            }
            throw new RuntimeException("upload image/ video to qiniu cloud has error,[ " + e.getMessage() + " ]");
        }
    }

    @Override
    public void upload(byte[] data, String key) {
        try {
            Response response = this.uploadManager.put(data, key, this.auth.uploadToken(this.properties.getBucket()), new StringMap(), null, true);
            if (log.isDebugEnabled()) {
                log.debug("upload {},fileSize:{},response:{}", new Object[]{key, data.length, response});
            }
            if (200 == response.statusCode) {
                return;
            }
            throw new RuntimeException(response.getInfo());
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error("upload image/video to qi niu cloud has error", (Throwable)e);
            }
            throw new RuntimeException("upload image/ video to qiniu cloud has error,[ " + e.getMessage() + " ]");
        }
    }

    @Override
    public String download(String key) {
        return this.download(key, 3600L);
    }

    @Override
    public String download(String key, long expire) {
        String domainOfBucket = this.properties.getCname();
        String publicUrl = String.format("%s/%s", domainOfBucket, key);
        String finalUrl = this.auth.privateDownloadUrl(publicUrl, expire);
        if (log.isDebugEnabled()) {
            log.debug("the file url is : {}", (Object)finalUrl);
        }
        return finalUrl;
    }

    @Override
    public String publicDownload(String fileName) {
        try {
            String encodedFileName = URLEncoder.encode(fileName, "utf-8").replace("+", "%20");
            return String.format("%s/%s", this.properties.getCname(), encodedFileName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("encode error , origin:[" + fileName + "]");
        }
    }

    @Override
    public void delete(String key) {
        try {
            Response response = this.bucketManager.delete(this.properties.getBucket(), key);
            if (log.isDebugEnabled()) {
                log.debug("delete file {} response {}", (Object)key, (Object)response);
            }
            if (200 == response.statusCode) {
                return;
            }
            throw new RuntimeException(response.getInfo());
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error("delete image/video has error", (Throwable)e);
            }
            throw new RuntimeException("delete image/video has error,[ " + e.getMessage() + " ]");
        }
    }

    @Override
    public String getToken() {
        return this.auth.uploadToken(this.properties.getBucket());
    }
}

