/*
 * Decompiled with CFR 0.152.
 */
package cn.venny.qiniu.config;

import cn.venny.qiniu.annotation.EnableQiNiu;
import cn.venny.qiniu.properties.QiNiuProperties;
import cn.venny.qiniu.service.QiNiuUploadService;
import cn.venny.qiniu.service.impl.DefaultQiNiuUploadServiceImpl;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@org.springframework.context.annotation.Configuration
@ConditionalOnBean(annotation={EnableQiNiu.class})
@EnableConfigurationProperties(value={QiNiuProperties.class})
public class QiNiuAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={Region.class})
    public Region getRegion() {
        return Region.autoRegion();
    }

    @Bean
    @ConditionalOnMissingBean(value={Configuration.class})
    public Configuration getConfiguration(Region region) {
        return new Configuration(region);
    }

    @Bean
    @ConditionalOnMissingBean(value={UploadManager.class})
    public UploadManager getUploadManager(Configuration configuration) {
        return new UploadManager(configuration);
    }

    @Bean
    @ConditionalOnMissingBean(value={Auth.class})
    public Auth getAuth(QiNiuProperties properties) {
        return Auth.create((String)properties.getAccessKey(), (String)properties.getAccessKeySecret());
    }

    @Bean
    @ConditionalOnMissingBean(value={BucketManager.class})
    public BucketManager getBucketManager(QiNiuProperties properties, Configuration configuration) {
        return new BucketManager(this.getAuth(properties), configuration);
    }

    @Bean
    @ConditionalOnMissingBean(value={QiNiuUploadService.class})
    public QiNiuUploadService qiNiuUploadService(Auth auth, QiNiuProperties properties, UploadManager uploadManager, BucketManager bucketManager) {
        return new DefaultQiNiuUploadServiceImpl(auth, properties, uploadManager, bucketManager);
    }
}

